/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.deploy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.deploy.Deployer;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentCache {
    protected Map<String, ProcessDefinitionEntity> processDefinitionCache = new HashMap<String, ProcessDefinitionEntity>();
    protected Map<String, Object> knowledgeBaseCache = new HashMap<String, Object>();
    protected List<Deployer> deployers;

    public void deploy(DeploymentEntity deployment) {
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment);
        }
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionById(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ActivitiException("Invalid process definition id : null");
        }
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiException("no deployed process definition found with id '" + processDefinitionId + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKey(String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionByKey(processDefinitionKey);
        if (processDefinition == null) {
            throw new ActivitiException("no processes deployed with key '" + processDefinitionKey + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByKeyAndVersion(String processDefinitionKey, Integer processDefinitionVersion) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionManager().findProcessDefinitionByKeyAndVersion(processDefinitionKey, processDefinitionVersion);
        if (processDefinition == null) {
            throw new ActivitiException("no processes deployed with key = '" + processDefinitionKey + "' and version = '" + processDefinitionVersion + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    protected ProcessDefinitionEntity resolveProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String processDefinitionId = processDefinition.getId();
        String deploymentId = processDefinition.getDeploymentId();
        processDefinition = this.processDefinitionCache.get(processDefinitionId);
        if (processDefinition == null) {
            DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
            deployment.setNew(false);
            this.deploy(deployment);
            processDefinition = this.processDefinitionCache.get(processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiException("deployment '" + deploymentId + "' didn't put process definition '" + processDefinitionId + "' in the cache");
            }
        }
        return processDefinition;
    }

    public void addProcessDefinition(ProcessDefinitionEntity processDefinition) {
        this.processDefinitionCache.put(processDefinition.getId(), processDefinition);
    }

    public void removeProcessDefinition(String processDefinitionId) {
        this.processDefinitionCache.remove(processDefinitionId);
    }

    public void addKnowledgeBase(String knowledgeBaseId, Object knowledgeBase) {
        this.knowledgeBaseCache.put(knowledgeBaseId, knowledgeBase);
    }

    public void removeKnowledgeBase(String knowledgeBaseId) {
        this.knowledgeBaseCache.remove(knowledgeBaseId);
    }

    public void discardProcessDefinitionCache() {
        this.processDefinitionCache.clear();
    }

    public void discardKnowledgeBaseCache() {
        this.knowledgeBaseCache.clear();
    }

    public Map<String, ProcessDefinitionEntity> getProcessDefinitionCache() {
        return this.processDefinitionCache;
    }

    public void setProcessDefinitionCache(Map<String, ProcessDefinitionEntity> processDefinitionCache) {
        this.processDefinitionCache = processDefinitionCache;
    }

    public Map<String, Object> getKnowledgeBaseCache() {
        return this.knowledgeBaseCache;
    }

    public void setKnowledgeBaseCache(Map<String, Object> knowledgeBaseCache) {
        this.knowledgeBaseCache = knowledgeBaseCache;
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }
}

