/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.EnumSet;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;

final class SnowballStemmer
extends Stemmer {
    private static final String PKG = "org.tartarus.snowball";
    private static final EnumMap<Language, StemmerClass> CLASSES = new EnumMap(Language.class);
    private StemmerClass clazz;
    private Object stemmer;

    static {
        if (Reflect.available(PKG)) {
            SnowballStemmer.add(Language.DA);
            SnowballStemmer.add(Language.DE);
            SnowballStemmer.add(Language.EN);
            SnowballStemmer.add(Language.ES);
            SnowballStemmer.add(Language.FI);
            SnowballStemmer.add(Language.FR);
            SnowballStemmer.add(Language.HU);
            SnowballStemmer.add(Language.IT);
            SnowballStemmer.add(Language.NL);
            SnowballStemmer.add(Language.NO);
            SnowballStemmer.add(Language.PT);
            SnowballStemmer.add(Language.RO);
            SnowballStemmer.add(Language.RU);
            SnowballStemmer.add(Language.SV);
            SnowballStemmer.add(Language.TR);
        }
    }

    private static void add(Language lang) {
        Class<?> clz = Reflect.find("org.tartarus.snowball.ext." + lang.toString().toLowerCase() + "Stemmer");
        CLASSES.put(lang, new StemmerClass(clz, Reflect.method(clz, "setCurrent", String.class), Reflect.method(clz, "stem", new Class[0]), Reflect.method(clz, "getCurrent", new Class[0])));
    }

    static boolean available() {
        return CLASSES.size() > 0;
    }

    SnowballStemmer() {
    }

    SnowballStemmer(Language lang, FTIterator fti) {
        super(fti);
        this.clazz = CLASSES.get((Object)lang);
        this.stemmer = Reflect.get(this.clazz.clz);
    }

    @Override
    Stemmer get(Language l, FTIterator fti) {
        return new SnowballStemmer(l, fti);
    }

    @Override
    public boolean supports(Language lang) {
        return CLASSES.containsKey((Object)lang);
    }

    @Override
    int prec() {
        return 100;
    }

    @Override
    EnumSet<Language> languages() {
        return EnumSet.copyOf(CLASSES.keySet());
    }

    @Override
    byte[] stem(byte[] word) {
        Reflect.invoke(this.clazz.setCurrent, this.stemmer, Token.string(word));
        Reflect.invoke(this.clazz.stem, this.stemmer, new Object[0]);
        return Token.token((String)Reflect.invoke(this.clazz.getCurrent, this.stemmer, new Object[0]));
    }

    private static class StemmerClass {
        final Class<?> clz;
        final Method setCurrent;
        final Method stem;
        final Method getCurrent;

        StemmerClass(Class<?> sc, Method s, Method stm, Method g) {
            this.clz = sc;
            this.setCurrent = s;
            this.stem = stm;
            this.getCurrent = g;
        }
    }
}

