/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.GroupPartition;
import org.basex.query.expr.Order;
import org.basex.query.expr.ParseExpr;
import org.basex.query.item.SeqType;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Group
extends ParseExpr {
    private final Var[] groupby;
    private final Var[][] nongroup;
    GroupPartition gp;

    public Group(InputInfo ii, Var[] gb, Var[] ng, Var[] ngc) {
        super(ii);
        this.groupby = gb;
        this.nongroup = new Var[][]{ng, ngc};
    }

    void init(Order ob) {
        this.gp = new GroupPartition(this.groupby, this.nongroup, ob, this.input);
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        Var[] varArray = this.groupby;
        int n = this.groupby.length;
        int n2 = 0;
        while (n2 < n) {
            Var g = varArray[n2];
            g.comp(ctx);
            if (g.ret != null) {
                g.ret = SeqType.get(g.ret.type, 1L);
            }
            ++n2;
        }
        varArray = this.nongroup[1];
        n = varArray.length;
        n2 = 0;
        while (n2 < n) {
            Var v = varArray[n2];
            ctx.vars.add(v);
            ++n2;
        }
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) {
        throw Util.notexpected(this);
    }

    @Override
    public boolean uses(Expr.Use use) {
        Var[] varArray = this.groupby;
        int n = this.groupby.length;
        int n2 = 0;
        while (n2 < n) {
            Var v = varArray[n2];
            if (v.uses(use)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int count(Var v) {
        Var g;
        int c = 0;
        Var[] varArray = this.groupby;
        int n = this.groupby.length;
        int n2 = 0;
        while (n2 < n) {
            g = varArray[n2];
            c += g.count(v);
            ++n2;
        }
        varArray = this.nongroup[0];
        n = varArray.length;
        n2 = 0;
        while (n2 < n) {
            g = varArray[n2];
            c += g.count(v);
            ++n2;
        }
        return c;
    }

    @Override
    public boolean removable(Var v) {
        Var g;
        Var[] varArray = this.groupby;
        int n = this.groupby.length;
        int n2 = 0;
        while (n2 < n) {
            g = varArray[n2];
            if (g.count(v) != 0) {
                return false;
            }
            ++n2;
        }
        varArray = this.nongroup[0];
        n = varArray.length;
        n2 = 0;
        while (n2 < n) {
            g = varArray[n2];
            if (g.count(v) != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Expr remove(Var v) {
        return this;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        int o = 0;
        while (o != this.groupby.length) {
            this.groupby[o].plan(ser);
            ++o;
        }
        ser.closeElement();
    }

    @Override
    public String toString() {
        return new TokenBuilder(" group by ").addSep(this.groupby, ", ").toString();
    }
}

