/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.item.Empty;
import org.basex.query.item.Itr;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Str;
import org.basex.query.item.Value;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Catch
extends Single {
    private static final QNm NS = new QNm(QueryText.ERR, QueryText.ERRORURI);
    private static final QNm[] QNM = new QNm[]{Catch.create(QueryText.ECODE), Catch.create(QueryText.EDESC), Catch.create(QueryText.EVALUE), Catch.create(QueryText.EMODULE), Catch.create(QueryText.ELINENUM), Catch.create(QueryText.ECOLNUM)};
    private static final SeqType[] TYPES = new SeqType[]{SeqType.QNM, SeqType.STR_ZO, SeqType.ITEM_ZM, SeqType.STR_ZO, SeqType.ITR_ZO, SeqType.ITR_ZO};
    private final QNm[] codes;
    private final Var[] vars = new Var[6];

    public Catch(InputInfo ii, QNm[] c, QueryContext ctx) {
        super(ii, null);
        this.codes = c;
        int i = 0;
        while (i < QNM.length) {
            this.vars[i] = Var.create(ctx, null, QNM[i], TYPES[i]);
            ++i;
        }
    }

    @Override
    public Catch comp(QueryContext ctx) throws QueryException {
        int s = this.prepare(ctx);
        super.comp(ctx);
        this.finish(s, ctx);
        return this;
    }

    Value value(QueryContext ctx, QueryException ex) throws QueryException {
        byte[] cd = Token.token(ex.code());
        if (!this.find(cd)) {
            return null;
        }
        int s = this.prepare(ctx);
        int i = 0;
        byte[] io = ex.file() == null ? Token.EMPTY : Token.token(ex.file().path());
        Value val = ex.value();
        Value[] valueArray = new Value[]{new QNm(cd, QueryText.ERRORURI), Str.get(ex.getLocalizedMessage()), val == null ? Empty.SEQ : val, Str.get(io), Itr.get(ex.col()), Itr.get(ex.line())};
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            this.vars[i++].bind(v, ctx);
            ++n2;
        }
        Value ir = ctx.value(this.expr);
        this.finish(s, ctx);
        return ir;
    }

    public int prepare(QueryContext ctx) throws QueryException {
        ctx.ns.add(NS, null);
        int s = ctx.vars.size();
        Var[] varArray = this.vars;
        int n = this.vars.length;
        int n2 = 0;
        while (n2 < n) {
            Var v = varArray[n2];
            ctx.vars.add(v);
            ++n2;
        }
        return s;
    }

    public void finish(int s, QueryContext ctx) {
        ctx.vars.reset(s);
        ctx.ns.delete(NS);
    }

    private boolean find(byte[] err) {
        QNm[] qNmArray = this.codes;
        int n = this.codes.length;
        int n2 = 0;
        while (n2 < n) {
            QNm c = qNmArray[n2];
            if (c == null || Token.eq(c.ln(), err)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR || super.uses(u);
    }

    @Override
    public String toString() {
        return "catch * { " + this.expr + " }";
    }

    private static QNm create(byte[] n) {
        return new QNm(Token.concat(QueryText.ERR, Token.COLON, n), QueryText.ERRORURI);
    }
}

