/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.zip.ZipInputStream;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

public class BufferInput
extends InputStream {
    private final byte[] cache = new byte[4];
    protected byte[] buffer;
    protected int pos;
    protected long length;
    private int size;
    private int len;
    private InputStream in;
    private String enc = "UTF-8";
    private CharsetDecoder csd;

    public BufferInput(String file) throws IOException {
        this(new File(file));
    }

    public BufferInput(File file) throws IOException {
        this(new FileInputStream(file));
        this.length = file.length();
    }

    public BufferInput(InputStream is) throws IOException {
        this(new byte[4096]);
        this.in = is;
        this.next();
    }

    protected BufferInput(byte[] buf) {
        this.buffer = buf;
        this.length = buf.length;
    }

    public final String encoding() {
        byte d;
        byte a = this.length > 0L ? this.buffer[0] : (byte)0;
        byte b = this.length > 1L ? this.buffer[1] : (byte)0;
        byte c = this.length > 2L ? this.buffer[2] : (byte)0;
        byte by = d = this.length > 3L ? this.buffer[3] : (byte)0;
        if (a == -1 && b == -2 || a == 60 && b == 0 && c == 63 && d == 0) {
            this.enc = "UTF-16LE";
            if (a == -1) {
                this.pos = 2;
            }
        } else if (a == -2 && b == -1 || a == 0 && b == 60 && c == 0 && d == 63) {
            this.enc = "UTF-16BE";
            if (a == -2) {
                this.pos = 2;
            }
        } else if (a == -17 && b == -69 && c == -65) {
            this.pos = 3;
        }
        return this.enc;
    }

    public final void encoding(String encoding) throws IOException {
        try {
            this.enc = Token.normEncoding(encoding, this.enc);
            this.csd = Charset.forName(encoding).newDecoder();
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public final int read() throws IOException {
        return this.readByte() & 0xFF;
    }

    public byte readByte() throws IOException {
        if (this.pos >= this.size) {
            this.next();
            if (this.size <= 0) {
                return 0;
            }
        }
        return this.buffer[this.pos++];
    }

    public final String readString() throws IOException {
        return this.token().toString();
    }

    public final ByteList token() throws IOException {
        byte l;
        ByteList bl = new ByteList();
        while ((l = this.readByte()) != 0) {
            bl.add(l);
        }
        return bl;
    }

    private void next() throws IOException {
        this.pos = 0;
        this.len += this.size;
        this.size = this.in.read(this.buffer);
    }

    public final int readChar() throws IOException {
        byte ch = this.readByte();
        if (this.enc == "UTF-8") {
            int cl = Token.cl(ch);
            if (cl == 1) {
                return ch & 0xFF;
            }
            this.cache[0] = ch;
            int c = 1;
            while (c < cl) {
                this.cache[c] = this.readByte();
                ++c;
            }
            return Token.cp(this.cache, 0);
        }
        if (this.enc == "UTF-16LE") {
            return ch & 0xFF | (this.readByte() & 0xFF) << 8;
        }
        if (this.enc == "UTF-16BE") {
            return (ch & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        if (ch >= 0) {
            return ch;
        }
        int p = 0;
        if (p == 4) {
            return -this.cache[0];
        }
        this.cache[p++] = ch;
        try {
            CharBuffer cb = this.csd.decode(ByteBuffer.wrap(Arrays.copyOf(this.cache, p)));
            int i = 0;
            int c = 0;
            while (c < cb.limit()) {
                i |= cb.get(c) << (c << 3);
                ++c;
            }
            return i;
        }
        catch (CharacterCodingException ex) {
            return ch & 0xFF;
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.in != null && !(this.in instanceof ZipInputStream)) {
            this.in.close();
        }
    }

    final int size() {
        return this.len + this.pos;
    }

    final long length() {
        return this.length;
    }

    public final void length(long l) {
        this.length = l;
    }
}

