/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.JAXBUtil;
import com.evolveum.midpoint.util.aspect.MidpointAspect;
import com.evolveum.midpoint.util.aspect.ObjectFormatter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DebugUtil
implements ObjectFormatter {
    private static int SHOW_LIST_MEMBERS = 3;
    private static String defaultNamespacePrefix = null;

    static {
        DebugUtil f = new DebugUtil();
        MidpointAspect.registerFormatter(f);
    }

    public static void setDefaultNamespacePrefix(String prefix) {
        defaultNamespacePrefix = prefix;
    }

    public static String dump(Dumpable dumpable) {
        if (dumpable == null) {
            return "null";
        }
        return dumpable.dump();
    }

    public static String dump(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Dumpable) {
            return ((Dumpable)object).dump();
        }
        if (object instanceof Map) {
            StringBuilder sb = new StringBuilder();
            DebugUtil.debugDumpMapMultiLine(sb, (Map)object, 0);
            return sb.toString();
        }
        if (object instanceof Collection) {
            return DebugUtil.debugDump((Collection)object);
        }
        return object.toString();
    }

    public static String debugDump(Collection<?> dumpables) {
        return DebugUtil.debugDump(dumpables, 0);
    }

    public static String debugDump(Collection<?> dumpables, int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(DebugUtil.getCollectionOpeningSymbol(dumpables));
        for (Object item : dumpables) {
            sb.append("\n");
            if (item == null) {
                DebugUtil.indentDebugDump(sb, indent + 1);
                sb.append("null");
                continue;
            }
            if (item instanceof DebugDumpable) {
                sb.append(((DebugDumpable)item).debugDump(indent + 1));
                continue;
            }
            DebugUtil.indentDebugDump(sb, indent + 1);
            sb.append(item.toString());
        }
        if (!dumpables.isEmpty()) {
            sb.append("\n");
        }
        sb.append(DebugUtil.getCollectionClosingSymbol(dumpables));
        return sb.toString();
    }

    public static String debugDump(Object object, int indent) {
        if (object instanceof DebugDumpable) {
            return ((DebugDumpable)object).debugDump(indent);
        }
        if (object instanceof Collection) {
            return DebugUtil.debugDump((Collection)object, indent);
        }
        StringBuilder sb = new StringBuilder();
        DebugUtil.indentDebugDump(sb, indent + 1);
        sb.append(object.toString());
        return sb.toString();
    }

    public static void debugDumpWithLabel(StringBuilder sb, String label, DebugDumpable dd, int indent) {
        DebugUtil.indentDebugDump(sb, indent);
        sb.append(label).append(":");
        if (dd == null) {
            sb.append(" null");
        } else {
            sb.append("\n");
            sb.append(dd.debugDump(indent + 1));
        }
    }

    public static <K, V extends DebugDumpable> void debugDumpWithLabel(StringBuilder sb, String label, Map<K, V> map, int indent) {
        DebugUtil.indentDebugDump(sb, indent);
        sb.append(label).append(":");
        if (map == null) {
            sb.append(" null");
        } else {
            sb.append("\n");
            DebugUtil.debugDumpMapMultiLine(sb, map, indent + 1);
        }
    }

    public static void debugDumpWithLabelToString(StringBuilder sb, String label, Object object, int indent) {
        DebugUtil.indentDebugDump(sb, indent);
        sb.append(label).append(":");
        if (object == null) {
            sb.append(" null");
        } else {
            sb.append(" ");
            sb.append(object.toString());
        }
    }

    public static String debugDumpXsdAnyProperties(Collection<?> xsdAnyCollection, int indent) {
        StringBuilder sb = new StringBuilder();
        DebugUtil.indentDebugDump(sb, indent);
        sb.append(DebugUtil.getCollectionOpeningSymbol(xsdAnyCollection));
        for (Object element : xsdAnyCollection) {
            sb.append("\n");
            DebugUtil.indentDebugDump(sb, indent + 1);
            sb.append(DebugUtil.prettyPrintElementAsProperty(element));
        }
        sb.append("\n");
        DebugUtil.indentDebugDump(sb, indent);
        sb.append(DebugUtil.getCollectionClosingSymbol(xsdAnyCollection));
        return sb.toString();
    }

    private static String prettyPrintElementAsProperty(Object element) {
        if (element == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("<");
        QName elementName = JAXBUtil.getElementQName(element);
        sb.append(DebugUtil.prettyPrint(elementName));
        sb.append(">");
        if (element instanceof Element) {
            Element domElement = (Element)element;
            sb.append(domElement.getTextContent());
        } else {
            sb.append(element.toString());
        }
        return sb.toString();
    }

    private static String getCollectionOpeningSymbol(Collection<?> col) {
        if (col instanceof List) {
            return "[";
        }
        if (col instanceof Set) {
            return "{";
        }
        return String.valueOf(col.getClass().getSimpleName()) + "(";
    }

    private static String getCollectionClosingSymbol(Collection<?> col) {
        if (col instanceof List) {
            return "]";
        }
        if (col instanceof Set) {
            return "}";
        }
        return ")";
    }

    public static void indentDebugDump(StringBuilder sb, int indent) {
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
    }

    public static <K, V> void debugDumpMapMultiLine(StringBuilder sb, Map<K, V> map, int indent) {
        Iterator<Map.Entry<K, V>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<K, V> entry = i.next();
            DebugUtil.indentDebugDump(sb, indent);
            sb.append(DebugUtil.prettyPrint(entry.getKey()));
            sb.append(" => ");
            V value = entry.getValue();
            if (value == null) {
                sb.append("null");
            } else if (value instanceof DebugDumpable) {
                sb.append("\n");
                sb.append(((DebugDumpable)value).debugDump(indent + 1));
            } else {
                sb.append(value);
            }
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
    }

    public static <K, V> void debugDumpMapSingleLine(StringBuilder sb, Map<K, V> map, int indent) {
        Iterator<Map.Entry<K, V>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<K, V> entry = i.next();
            DebugUtil.indentDebugDump(sb, indent);
            sb.append(DebugUtil.prettyPrint(entry.getKey()));
            sb.append(" => ");
            V value = entry.getValue();
            if (value == null) {
                sb.append("null");
            } else {
                sb.append(value);
            }
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
    }

    public static String prettyPrint(Collection<?> collection) {
        return DebugUtil.prettyPrint(collection, 0);
    }

    public static String prettyPrint(Collection<?> collection, int maxItems) {
        if (collection == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(DebugUtil.getCollectionOpeningSymbol(collection));
        Iterator<?> iterator = collection.iterator();
        int items = 0;
        while (iterator.hasNext()) {
            sb.append(DebugUtil.prettyPrint(iterator.next()));
            ++items;
            if (!iterator.hasNext()) continue;
            sb.append(",");
            if (maxItems == 0 || items < maxItems) continue;
            sb.append("...");
            break;
        }
        sb.append(DebugUtil.getCollectionClosingSymbol(collection));
        return sb.toString();
    }

    public static String prettyPrint(QName qname) {
        if (qname == null) {
            return "null";
        }
        if (defaultNamespacePrefix != null && qname.getNamespaceURI() != null && qname.getNamespaceURI().startsWith(defaultNamespacePrefix)) {
            return "{..." + qname.getNamespaceURI().substring(defaultNamespacePrefix.length()) + "}" + qname.getLocalPart();
        }
        return qname.toString();
    }

    public static String prettyPrint(List<Element> list) {
        if (list == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (list.size() > 0) {
            Element el0 = list.get(0);
            QName elQName = el0.getPrefix() != null ? new QName(el0.getNamespaceURI(), el0.getLocalName(), el0.getPrefix()) : new QName(el0.getNamespaceURI(), el0.getLocalName());
            sb.append(elQName);
            sb.append("[");
            Iterator<Element> iterator = list.iterator();
            while (iterator.hasNext()) {
                Element el = iterator.next();
                sb.append(DebugUtil.prettyPrint(el, false));
                if (iterator.hasNext()) {
                    sb.append(",");
                }
                sb.append("]");
            }
        } else {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static String prettyPrint(Node node) {
        if (node instanceof Element) {
            return DebugUtil.prettyPrint((Element)node);
        }
        return "Node:" + node.getNodeName();
    }

    public static String prettyPrint(Element element) {
        return DebugUtil.prettyPrint(element, true);
    }

    public static String prettyPrint(Element element, boolean displayTag) {
        if (element == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (displayTag) {
            sb.append("<");
            if (element.getLocalName() != null) {
                sb.append(DebugUtil.prettyPrint(new QName(element.getNamespaceURI(), element.getLocalName())));
            } else {
                sb.append("<null>");
            }
            sb.append(">");
        }
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attr = attributes.item(i);
            if (!("xmlns".equals(attr.getPrefix()) || (attr.getPrefix() == null || attr.getPrefix().isEmpty()) && "xmlns".equals(attr.getLocalName()))) {
                sb.append("@");
                sb.append(attr.getLocalName());
                sb.append("=");
                sb.append(attr.getTextContent());
                if (i < attributes.getLength() - 1) {
                    sb.append(",");
                }
            }
            ++i;
        }
        if (attributes.getLength() > 0) {
            sb.append(":");
        }
        StringBuilder content = new StringBuilder();
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                content.append(((Text)child).getTextContent());
            } else if (child.getNodeType() != 8) {
                content = new StringBuilder("[complex content]");
                break;
            }
            child = child.getNextSibling();
        }
        sb.append((CharSequence)content);
        return sb.toString();
    }

    public static String prettyPrint(Object value) {
        Object elementValue;
        if (value == null) {
            return "null";
        }
        String out = null;
        if (value instanceof JAXBElement && (out = DebugUtil.tryPrettyPrint(elementValue = ((JAXBElement)value).getValue())) != null) {
            return "JAXBElement(" + ((JAXBElement)value).getName() + "," + out + ")";
        }
        out = DebugUtil.tryPrettyPrint(value);
        if (out == null) {
            out = value.toString();
        }
        return out;
    }

    private static String tryPrettyPrint(Object value) {
        if (value instanceof Class) {
            Class c = (Class)value;
            if (c.getPackage().getName().equals("com.evolveum.midpoint.xml.ns._public.common.common_2")) {
                return c.getSimpleName();
            }
            return c.getName();
        }
        if (value instanceof Collection) {
            return DebugUtil.prettyPrint((Collection)value);
        }
        if (value instanceof Node) {
            return DebugUtil.prettyPrint((Node)value);
        }
        Method[] methodArray = DebugUtil.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameterTypes;
            Method method = methodArray[n2];
            if (method.getName().equals("prettyPrint") && (parameterTypes = method.getParameterTypes()).length == 1 && parameterTypes[0].equals(value.getClass())) {
                try {
                    return (String)method.invoke(null, value);
                }
                catch (IllegalArgumentException e) {
                    return "###INTERNAL#ERROR### Illegal argument: " + e.getMessage();
                }
                catch (IllegalAccessException e) {
                    return "###INTERNAL#ERROR### Illegal access: " + e.getMessage();
                }
                catch (InvocationTargetException e) {
                    return "###INTERNAL#ERROR### Illegal target: " + e.getMessage();
                }
                catch (Throwable e) {
                    return "###INTERNAL#ERROR### " + e.getClass().getName() + ": " + e.getMessage();
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String format(Object o) {
        try {
            return DebugUtil.prettyPrint(o);
        }
        catch (Throwable t) {
            return "###INTERNAL#ERROR### " + t.getClass().getName() + ": " + t.getMessage();
        }
    }
}

