/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.query;

import com.evolveum.midpoint.repo.sql.query.QueryException;
import com.evolveum.midpoint.repo.sql.query.QueryInterpreter;
import com.evolveum.midpoint.util.DOMUtil;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.hibernate.criterion.Criterion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class Op {
    private QueryInterpreter interpreter;

    public Op(QueryInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public boolean canHandle(Element filter) {
        if (this.canHandle() == null || filter == null) {
            return false;
        }
        QName[] qNameArray = this.canHandle();
        int n = qNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            QName qname = qNameArray[n2];
            if (DOMUtil.isElementName((Element)filter, (QName)qname)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void validate(Element filter) throws QueryException {
        if (!this.canHandle(filter)) {
            throw new QueryException("Can't handle filter '" + DOMUtil.getQNameWithoutPrefix((Node)filter) + "', only: " + Arrays.toString(this.canHandle()));
        }
    }

    protected QueryInterpreter getInterpreter() {
        return this.interpreter;
    }

    protected abstract QName[] canHandle();

    public abstract Criterion interpret(Element var1, boolean var2) throws QueryException;
}

