/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RContainerType;
import com.evolveum.midpoint.repo.sql.util.ClassMapper;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Type;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Embeddable
public class REmbeddedReference
implements Serializable {
    private String targetOid;
    private String description;
    private String filter;
    private RContainerType type;

    @Column(length=36, insertable=true, updatable=true, nullable=true)
    public String getTargetOid() {
        return this.targetOid;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getDescription() {
        return this.description;
    }

    @Enumerated(value=EnumType.ORDINAL)
    public RContainerType getType() {
        return this.type;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getFilter() {
        return this.filter;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setTargetOid(String targetOid) {
        this.targetOid = targetOid;
    }

    public void setType(RContainerType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        REmbeddedReference that = (REmbeddedReference)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.targetOid != null ? !this.targetOid.equals(that.targetOid) : that.targetOid != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.description != null ? this.description.hashCode() : 0;
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static void copyToJAXB(REmbeddedReference repo, ObjectReferenceType jaxb, PrismContext prismContext) {
        String filter;
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        jaxb.setDescription(repo.getDescription());
        jaxb.setType(ClassMapper.getQNameForHQLType(repo.getType()));
        if (StringUtils.isNotEmpty((String)repo.getTargetOid())) {
            jaxb.setOid(repo.getTargetOid());
        }
        if (StringUtils.isNotEmpty((String)(filter = repo.getFilter()))) {
            Element element = DOMUtil.parseDocument((String)filter).getDocumentElement();
            ObjectReferenceType.Filter jaxbFilter = new ObjectReferenceType.Filter();
            jaxbFilter.setFilter(element);
            jaxb.setFilter(jaxbFilter);
        }
    }

    public static void copyFromJAXB(ObjectReferenceType jaxb, REmbeddedReference repo, PrismContext prismContext) {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        repo.setDescription(jaxb.getDescription());
        repo.setType(ClassMapper.getHQLTypeForQName(jaxb.getType()));
        repo.setTargetOid(jaxb.getOid());
        if (jaxb.getFilter() != null && jaxb.getFilter().getFilter() != null) {
            ObjectReferenceType.Filter filter = jaxb.getFilter();
            repo.setFilter(DOMUtil.printDom((Node)filter.getFilter()).toString());
        }
    }

    public ObjectReferenceType toJAXB(PrismContext prismContext) {
        ObjectReferenceType ref = new ObjectReferenceType();
        REmbeddedReference.copyToJAXB(this, ref, prismContext);
        return ref;
    }
}

