/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.api;

import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;

public class ResourceObjectShadowChangeDescription
implements Dumpable,
DebugDumpable {
    private ObjectDelta<? extends ResourceObjectShadowType> objectDelta;
    private PrismObject<? extends ResourceObjectShadowType> currentShadow;
    private PrismObject<? extends ResourceObjectShadowType> oldShadow;
    private String sourceChannel;
    private PrismObject<ResourceType> resource;

    public ObjectDelta<? extends ResourceObjectShadowType> getObjectDelta() {
        return this.objectDelta;
    }

    public void setObjectDelta(ObjectDelta<? extends ResourceObjectShadowType> objectDelta) {
        this.objectDelta = objectDelta;
    }

    public PrismObject<? extends ResourceObjectShadowType> getCurrentShadow() {
        return this.currentShadow;
    }

    public void setCurrentShadow(PrismObject<? extends ResourceObjectShadowType> currentShadow) {
        this.currentShadow = currentShadow;
    }

    public PrismObject<? extends ResourceObjectShadowType> getOldShadow() {
        return this.oldShadow;
    }

    public void setOldShadow(PrismObject<? extends ResourceObjectShadowType> oldShadow) {
        this.oldShadow = oldShadow;
    }

    public String getSourceChannel() {
        return this.sourceChannel;
    }

    public void setSourceChannel(String sourceChannel) {
        this.sourceChannel = sourceChannel;
    }

    public PrismObject<ResourceType> getResource() {
        return this.resource;
    }

    public void setResource(PrismObject<ResourceType> resource) {
        this.resource = resource;
    }

    public void checkConsistence() {
        if (this.resource == null) {
            throw new IllegalArgumentException("No resource in " + this.getClass().getSimpleName());
        }
        this.resource.checkConsistence();
        if (this.sourceChannel == null) {
            throw new IllegalArgumentException("No sourceChannel in " + this.getClass().getSimpleName());
        }
        if (this.objectDelta == null && this.currentShadow == null) {
            throw new IllegalArgumentException("Either objectDelta or currentShadow must be set in " + this.getClass().getSimpleName());
        }
        if (this.objectDelta != null && this.objectDelta.getOid() == null) {
            throw new IllegalArgumentException("Delta OID not set in " + this.getClass().getSimpleName());
        }
        if (this.objectDelta != null) {
            this.objectDelta.checkConsistence();
        }
        if (this.currentShadow != null && this.currentShadow.getOid() == null) {
            throw new IllegalArgumentException("Current shadow OID not set in " + this.getClass().getSimpleName());
        }
        if (this.currentShadow != null) {
            this.currentShadow.checkConsistence();
        }
    }

    public String toString() {
        return "ResourceObjectShadowChangeDescription(objectDelta=" + this.objectDelta + ", currentShadow=" + SchemaDebugUtil.prettyPrint(this.currentShadow) + ", oldShadow=" + SchemaDebugUtil.prettyPrint(this.oldShadow) + ", sourceChannel=" + this.sourceChannel + ", resource=" + this.resource + ")";
    }

    public String dump() {
        return this.debugDump(0);
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        SchemaDebugUtil.indentDebugDump((StringBuilder)sb, (int)indent);
        sb.append("ResourceObjectShadowChangeDescription(");
        sb.append(this.sourceChannel);
        sb.append(")\n");
        SchemaDebugUtil.indentDebugDump((StringBuilder)sb, (int)(indent + 1));
        sb.append("resource:");
        if (this.resource == null) {
            sb.append(" null");
        } else {
            sb.append(this.resource);
        }
        sb.append("\n");
        SchemaDebugUtil.indentDebugDump((StringBuilder)sb, (int)(indent + 1));
        sb.append("objectDelta:");
        if (this.objectDelta == null) {
            sb.append(" null");
        } else {
            sb.append(this.objectDelta.debugDump(indent + 2));
        }
        sb.append("\n");
        SchemaDebugUtil.indentDebugDump((StringBuilder)sb, (int)(indent + 1));
        sb.append("oldShadow:");
        if (this.oldShadow == null) {
            sb.append(" null");
        } else {
            sb.append(this.oldShadow.debugDump(indent + 2));
        }
        sb.append("\n");
        SchemaDebugUtil.indentDebugDump((StringBuilder)sb, (int)(indent + 1));
        sb.append("currentShadow:");
        if (this.currentShadow == null) {
            sb.append(" null\n");
        } else {
            sb.append("\n");
            sb.append(this.currentShadow.debugDump(indent + 2));
        }
        return sb.toString();
    }
}

