/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.crypto;

import com.evolveum.midpoint.common.crypto.EncryptionException;
import com.evolveum.midpoint.common.crypto.Protector;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.xml.PrismJaxbProcessor;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ProtectedStringType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.SecretKey;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3._2000._09.xmldsig.KeyInfoType;
import org.w3._2001._04.xmlenc.EncryptedDataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AESProtector
implements Protector {
    private static final Trace LOGGER = TraceManager.getTrace(AESProtector.class);
    private static final QName QNAME_KEY_NAME = new QName("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    private static final QName QNAME_ENCRYPTED_DATA = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
    private static final String KEY_DIGEST_TYPE = "SHA1";
    private static final char[] KEY_PASSWORD = "midpoint".toCharArray();
    private static final String ENCRYPTED_ELEMENT_NAME = "value";
    private String keyStorePath;
    private String keyStorePassword;
    private String encryptionKeyAlias = "default";
    private String xmlCipher;
    private List<TrustManager> trustManagers;
    private static final KeyStore keyStore;
    @Autowired(required=true)
    private PrismContext prismContext;

    static {
        Init.init();
        try {
            keyStore = KeyStore.getInstance("jceks");
        }
        catch (KeyStoreException ex) {
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void init() {
        InputStream stream = null;
        try {
            File f = new File(this.getKeyStorePath());
            if (f.exists()) {
                LOGGER.info("Using file keystore at {}", (Object)this.getKeyStorePath());
                if (!f.canRead()) {
                    LOGGER.error("Provided keystore file {} is unreadable.", (Object)this.getKeyStorePath());
                    throw new EncryptionException("Provided keystore file " + this.getKeyStorePath() + " is unreadable.");
                }
                stream = new FileInputStream(f);
            } else {
                LOGGER.warn("Using default keystore from classpath ({}).", (Object)this.getKeyStorePath());
                stream = AESProtector.class.getClassLoader().getResourceAsStream(this.getKeyStorePath());
                if (stream == null) {
                    stream = AESProtector.class.getClassLoader().getResourceAsStream("com/../../" + this.getKeyStorePath());
                }
            }
            if (stream == null) {
                throw new EncryptionException("Couldn't load keystore as resource '" + this.getKeyStorePath() + "'");
            }
            keyStore.load(stream, this.getKeyStorePassword().toCharArray());
            stream.close();
            TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmFactory.init(keyStore);
            this.trustManagers = new ArrayList<TrustManager>();
            TrustManager[] trustManagerArray = tmFactory.getTrustManagers();
            int n = trustManagerArray.length;
            int n2 = 0;
            while (n2 < n) {
                TrustManager trustManager = trustManagerArray[n2];
                this.trustManagers.add(trustManager);
                ++n2;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to work with keystore {}, reason {}.", (Object)new Object[]{this.getKeyStorePath(), ex.getMessage()}, (Object)ex);
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getXmlCipher() {
        if (this.xmlCipher == null) {
            this.xmlCipher = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        }
        return this.xmlCipher;
    }

    public void setXmlCipher(String xmlCipher) {
        this.xmlCipher = xmlCipher;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    private String getEncryptionKeyAlias() {
        if (StringUtils.isEmpty((String)this.encryptionKeyAlias)) {
            throw new IllegalStateException("Encryption key alias was not defined (is null or empty).");
        }
        return this.encryptionKeyAlias;
    }

    public void setEncryptionKeyAlias(String encryptionKeyAlias) {
        Validate.notEmpty((String)encryptionKeyAlias, (String)"Encryption key alias must not be null or empty.");
        this.encryptionKeyAlias = encryptionKeyAlias;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        Validate.notNull((Object)keyStorePassword, (String)"Keystore password must not be null.");
        this.keyStorePassword = keyStorePassword;
    }

    private String getKeyStorePassword() {
        if (this.keyStorePassword == null) {
            throw new IllegalStateException("Keystore password was not defined (null).");
        }
        return this.keyStorePassword;
    }

    public void setKeyStorePath(String keyStorePath) {
        Validate.notEmpty((String)keyStorePath, (String)"Key store path must not be null.");
        this.keyStorePath = keyStorePath;
    }

    private String getKeyStorePath() {
        if (StringUtils.isEmpty((String)this.keyStorePath)) {
            throw new IllegalStateException("Keystore path was not defined (is null or empty).");
        }
        return this.keyStorePath;
    }

    @Override
    public String decryptString(ProtectedStringType protectedString) throws EncryptionException {
        Element plain = this.decrypt(protectedString);
        if (plain == null) {
            return null;
        }
        return plain.getTextContent();
    }

    @Override
    public Element decrypt(ProtectedStringType protectedString) throws EncryptionException {
        Document document;
        Validate.notNull((Object)protectedString, (String)"Protected string must not be null.");
        EncryptedDataType encrypted = protectedString.getEncryptedData();
        Validate.notNull((Object)encrypted, (String)"Encrypted data must not be null.");
        if (encrypted.getCipherData() == null || (encrypted.getCipherData().getCipherValue() == null || encrypted.getCipherData().getCipherValue().length == 0) && (encrypted.getCipherData().getCipherReference() == null || encrypted.getCipherData().getCipherReference().getURI() == null)) {
            throw new IllegalArgumentException("CipherData element is missing or empty");
        }
        try {
            String digest = this.getDefaultSecretKeyDigest();
            if (encrypted.getKeyInfo() != null) {
                KeyInfoType keyInfo = encrypted.getKeyInfo();
                List infos = keyInfo.getContent();
                for (Object object : infos) {
                    JAXBElement info;
                    if (!(object instanceof JAXBElement) || !QNAME_KEY_NAME.equals((info = (JAXBElement)object).getName())) continue;
                    digest = info.getValue().toString();
                    break;
                }
            }
            SecretKey secret = this.getSecretKeyByDigest(digest);
            XMLCipher xmlCipher = XMLCipher.getInstance((String)this.getXmlCipher());
            xmlCipher.init(2, (Key)secret);
            document = DOMUtil.getDocument();
            Element element = this.getJaxbProcessor().marshalObjectToDom((Object)encrypted, QNAME_ENCRYPTED_DATA, document);
            document.appendChild(element);
            document = null;
            document = xmlCipher.doFinal(element.getOwnerDocument(), element);
        }
        catch (EncryptionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Exception during decryption: {}", (Object)ex.getMessage(), (Object)ex);
            try {
                LOGGER.trace("The input was {}:\n{}", (Object)protectedString, (Object)this.getJaxbProcessor().marshalObjectToDom((Object)protectedString, SchemaConstants.R_PROTECTED_STRING, DOMUtil.getDocument()));
            }
            catch (JAXBException e) {
                LOGGER.trace("Error marshalling the input {}: {}", (Object)protectedString, (Object)e.getMessage());
            }
            throw new EncryptionException(ex.getMessage(), ex);
        }
        if (document == null) {
            return null;
        }
        return document.getDocumentElement();
    }

    @Override
    public ProtectedStringType encryptString(String text) throws EncryptionException {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        return this.encrypt(this.stringToElement(text));
    }

    private Element stringToElement(String text) {
        Document document = DOMUtil.getDocument();
        Element plain = document.createElement(ENCRYPTED_ELEMENT_NAME);
        plain.setTextContent(text);
        document.appendChild(plain);
        return plain;
    }

    @Override
    public ProtectedStringType encrypt(Element plain) throws EncryptionException {
        return this.encrypt(plain, new ProtectedStringType());
    }

    private ProtectedStringType encrypt(Element plain, ProtectedStringType protectedString) throws EncryptionException {
        if (plain == null) {
            return null;
        }
        try {
            SecretKey secret = this.getSecretKeyByAlias(this.getEncryptionKeyAlias());
            XMLCipher xmlCipher = XMLCipher.getInstance((String)this.getXmlCipher());
            xmlCipher.init(1, (Key)secret);
            Document document = plain.getOwnerDocument();
            if (document == null) {
                document = DOMUtil.getDocument();
                document.appendChild(plain);
            }
            KeyInfo keyInfo = new KeyInfo(document);
            keyInfo.addKeyName(this.getSecretKeyDigest(secret));
            xmlCipher.getEncryptedData().setKeyInfo(keyInfo);
            document = xmlCipher.doFinal(document, plain);
            EncryptedDataType data = (EncryptedDataType)this.getJaxbProcessor().unmarshalToObject((Node)document.getDocumentElement(), EncryptedDataType.class);
            protectedString.setEncryptedData(data);
        }
        catch (EncryptionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EncryptionException(ex.getMessage(), ex);
        }
        return protectedString;
    }

    @Override
    public void encrypt(ProtectedStringType ps) throws EncryptionException {
        String clearValue = ps.getClearValue();
        if (clearValue == null) {
            return;
        }
        ps.setClearValue(null);
        this.encrypt(this.stringToElement(clearValue), ps);
    }

    private String getSecretKeyDigest(SecretKey key) throws EncryptionException {
        MessageDigest sha1 = null;
        try {
            sha1 = MessageDigest.getInstance(KEY_DIGEST_TYPE);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptionException(ex.getMessage(), ex);
        }
        return Base64.encode((byte[])sha1.digest(key.getEncoded()));
    }

    private String getDefaultSecretKeyDigest() throws EncryptionException {
        return this.getSecretKeyDigest(this.getSecretKeyByAlias(this.getEncryptionKeyAlias()));
    }

    private SecretKey getSecretKeyByAlias(String alias) throws EncryptionException {
        Key key = null;
        try {
            key = keyStore.getKey(alias, KEY_PASSWORD);
        }
        catch (Exception ex) {
            throw new EncryptionException("Couldn't obtain key '" + alias + "' from keystore, reason: " + ex.getMessage(), ex);
        }
        if (key == null || !(key instanceof SecretKey)) {
            throw new EncryptionException("Key with alias '" + alias + "' is not instance of SecretKey, but '" + key + "'.");
        }
        return (SecretKey)key;
    }

    private SecretKey getSecretKeyByDigest(String digest) throws EncryptionException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                try {
                    String keyHash;
                    Key key = keyStore.getKey(alias, KEY_PASSWORD);
                    if (!(key instanceof SecretKey) || !digest.equals(keyHash = this.getSecretKeyDigest((SecretKey)key))) continue;
                    return (SecretKey)key;
                }
                catch (UnrecoverableKeyException ex) {
                    LOGGER.trace("Couldn't recover key {} from keystore, reason: {}", new Object[]{alias, ex.getMessage()});
                }
            }
        }
        catch (Exception ex) {
            throw new EncryptionException(ex.getMessage(), ex);
        }
        throw new EncryptionException("Key '" + digest + "' is not in keystore.");
    }

    @Override
    public boolean isEncrypted(ProtectedStringType ps) {
        if (ps == null) {
            return false;
        }
        return ps.getEncryptedData() != null;
    }

    @Override
    public List<TrustManager> getTrustManagers() {
        return this.trustManagers;
    }

    private PrismJaxbProcessor getJaxbProcessor() {
        return this.prismContext.getPrismJaxbProcessor();
    }
}

