/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync;

import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.provisioning.api.ResourceObjectChangeListener;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.provisioning.api.ResultHandler;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;

public class SynchronizeAccountResultHandler
implements ResultHandler<AccountShadowType> {
    private static final Trace LOGGER = TraceManager.getTrace(SynchronizeAccountResultHandler.class);
    private ResourceObjectChangeListener objectChangeListener;
    private Task task;
    private ResourceType resource;
    private RefinedAccountDefinition refinedAccountDefinition;
    private QName sourceChannel;
    private String processShortName;
    private long progress;
    private long errors;
    private boolean stopOnError;
    private boolean forceAdd;

    public SynchronizeAccountResultHandler(ResourceType resource, RefinedAccountDefinition refinedAccountDefinition, Task task, ResourceObjectChangeListener objectChangeListener) {
        this.objectChangeListener = objectChangeListener;
        this.task = task;
        this.resource = resource;
        this.refinedAccountDefinition = refinedAccountDefinition;
        this.progress = 0L;
        this.errors = 0L;
        this.stopOnError = true;
        this.forceAdd = false;
        this.processShortName = "synchronization";
    }

    public boolean isForceAdd() {
        return this.forceAdd;
    }

    public void setForceAdd(boolean forceAdd) {
        this.forceAdd = forceAdd;
    }

    public QName getSourceChannel() {
        return this.sourceChannel;
    }

    public void setSourceChannel(QName sourceChannel) {
        this.sourceChannel = sourceChannel;
    }

    public String getProcessShortName() {
        return this.processShortName;
    }

    private String getProcessShortNameCapitalized() {
        return StringUtils.capitalize((String)this.processShortName);
    }

    public void setProcessShortName(String processShortName) {
        this.processShortName = processShortName;
    }

    public boolean handle(PrismObject<AccountShadowType> accountShadow, OperationResult parentResult) {
        if (accountShadow.getOid() == null) {
            throw new IllegalArgumentException("Object has null OID");
        }
        ++this.progress;
        long startTime = System.currentTimeMillis();
        OperationResult result = parentResult.createSubresult(String.valueOf(SynchronizeAccountResultHandler.class.getName()) + ".handle");
        result.addParam("object", accountShadow);
        result.addContext("progress", (Object)this.progress);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{} {} from {}", new Object[]{this.getProcessShortNameCapitalized(), accountShadow, this.resource.asPrismObject()});
        }
        if (this.objectChangeListener == null) {
            LOGGER.warn("No object change listener set for {} task, ending the task", (Object)this.getProcessShortName());
            result.recordFatalError("No object change listener set for " + this.getProcessShortName() + " task, ending the task");
            return false;
        }
        try {
            AccountShadowType newShadowType = (AccountShadowType)accountShadow.asObjectable();
            ResourceObjectShadowChangeDescription change = new ResourceObjectShadowChangeDescription();
            change.setSourceChannel(QNameUtil.qNameToUri((QName)this.sourceChannel));
            change.setResource(this.resource.asPrismObject());
            if (this.forceAdd) {
                ObjectDelta shadowDelta = new ObjectDelta(AccountShadowType.class, ChangeType.ADD);
                PrismObject shadowToAdd = newShadowType.asPrismObject();
                shadowDelta.setObjectToAdd(shadowToAdd);
                shadowDelta.setOid(newShadowType.getOid());
                change.setObjectDelta(shadowDelta);
            } else {
                change.setCurrentShadow(accountShadow);
            }
            try {
                change.checkConsistence();
            }
            catch (RuntimeException ex) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Change:\n{}", (Object)change.dump());
                }
                throw ex;
            }
            this.objectChangeListener.notifyChange(change, this.task, result);
            long endTime = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} object {} from resource {} done ({} ms)", new Object[]{this.getProcessShortNameCapitalized(), ObjectTypeUtil.toShortString((ObjectType)newShadowType), ObjectTypeUtil.toShortString((ObjectType)this.resource), endTime - startTime});
            }
        }
        catch (Exception ex) {
            ++this.errors;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("{} of object {} from resource {} failed: {}", new Object[]{this.getProcessShortNameCapitalized(), accountShadow, this.resource.asPrismObject(), ex.getMessage(), ex});
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Change notication listener failed for {} of object {}: {}: ", new Object[]{this.getProcessShortName(), accountShadow, ex.getClass().getSimpleName(), ex.getMessage(), ex});
            }
            result.recordPartialError("failed to synchronize: " + ex.getMessage(), (Throwable)ex);
            return !this.isStopOnError();
        }
        if (result.isSuccess()) {
            result.getSubresults().clear();
        }
        if (this.task.canRun()) {
            result.computeStatus();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{} of {} finished, result: {}", new Object[]{this.getProcessShortNameCapitalized(), accountShadow, result.dump()});
            }
            return true;
        }
        result.recordPartialError("Interrupted");
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("{} from {} interrupted", new Object[]{this.getProcessShortNameCapitalized(), ObjectTypeUtil.toShortString((ObjectType)this.resource)});
        }
        return false;
    }

    public long heartbeat() {
        return this.progress;
    }

    public long getProgress() {
        return this.progress;
    }

    public long getErrors() {
        return this.errors;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }
}

