/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.filter;

import com.evolveum.midpoint.model.filter.AbstractFilter;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PatternFilter
extends AbstractFilter {
    public static final QName ELEMENT_REPLACE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/value-filter-1.xsd", "replace");
    public static final QName ELEMENT_PATTERN = new QName("http://midpoint.evolveum.com/xml/ns/public/common/value-filter-1.xsd", "pattern");
    public static final QName ELEMENT_REPLACEMENT = new QName("http://midpoint.evolveum.com/xml/ns/public/common/value-filter-1.xsd", "replacement");
    private static final Trace LOGGER = TraceManager.getTrace(PatternFilter.class);

    @Override
    public <T> PrismPropertyValue<T> apply(PrismPropertyValue<T> propertyValue) {
        Validate.notNull(propertyValue, (String)"Node must not be null.");
        String value = this.getStringValue(propertyValue);
        if (StringUtils.isEmpty((String)value)) {
            return propertyValue;
        }
        Validate.notEmpty(this.getParameters(), (String)"Parameters must not be null or empty.");
        List<Replace> replaces = this.getReplaces();
        for (Replace replace : replaces) {
            Matcher matcher = replace.getPattern().matcher(value);
            value = matcher.replaceAll(replace.getReplacement());
        }
        propertyValue.setValue((Object)value);
        return propertyValue;
    }

    private List<Replace> getReplaces() {
        ArrayList<Replace> replaces = new ArrayList<Replace>();
        List<Object> parameters = this.getParameters();
        for (Object object : parameters) {
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (!ELEMENT_REPLACE.getLocalPart().equals(element.getLocalName())) {
                LOGGER.debug("Ignoring unknown parameter {} in PatternFilter", new Object[]{element.getLocalName()});
                continue;
            }
            NodeList patternNodeList = element.getElementsByTagNameNS(ELEMENT_PATTERN.getNamespaceURI(), ELEMENT_PATTERN.getLocalPart());
            if (patternNodeList.getLength() != 1) {
                throw new IllegalArgumentException("Wrong number of " + ELEMENT_PATTERN + " elements (" + patternNodeList.getLength() + ")");
            }
            String patternStr = ((Element)patternNodeList.item(0)).getTextContent();
            Pattern pattern = Pattern.compile(patternStr);
            NodeList replacementNodeList = element.getElementsByTagNameNS(ELEMENT_REPLACEMENT.getNamespaceURI(), ELEMENT_REPLACEMENT.getLocalPart());
            if (replacementNodeList.getLength() != 1) {
                throw new IllegalArgumentException("Wrong number of " + ELEMENT_REPLACEMENT + " elements (" + replacementNodeList.getLength() + ")");
            }
            String replacement = ((Element)replacementNodeList.item(0)).getTextContent();
            replaces.add(new Replace(pattern, replacement));
        }
        return replaces;
    }

    private static class Replace {
        private String replacement;
        private Pattern pattern;

        public Replace(Pattern pattern, String replacement) {
            this.replacement = replacement;
            this.pattern = pattern;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

