/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.wf.activiti;

import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.wf.WfConfiguration;
import javax.annotation.PreDestroy;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.TaskService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.apache.commons.lang.Validate;
import org.springframework.stereotype.Component;

@Component
public class ActivitiEngine {
    private static final Trace LOGGER = TraceManager.getTrace(TaskManager.class);
    private static final String ADMINISTRATOR = "administrator";
    private ProcessEngine processEngine = null;
    private WfConfiguration wfConfiguration;

    public void initialize(WfConfiguration configuration) throws Exception {
        Validate.notNull((Object)configuration);
        this.wfConfiguration = configuration;
        LOGGER.trace("Attempting to create Activiti engine.");
        this.processEngine = ProcessEngineConfiguration.createStandaloneProcessEngineConfiguration().setDatabaseSchemaUpdate(configuration.isActivitiSchemaUpdate() ? "true" : "false").setJdbcUrl(configuration.getJdbcUrl()).setJdbcDriver(configuration.getJdbcDriver()).setJdbcUsername(configuration.getJdbcUser()).setJdbcPassword(configuration.getJdbcPassword()).setJobExecutorActivate(false).setHistory("audit").buildProcessEngine();
        LOGGER.info("Activiti engine successfully created.");
        IdentityService identityService = this.getIdentityService();
        UserQuery uq = identityService.createUserQuery().userId(ADMINISTRATOR);
        if (uq.count() == 0L) {
            User admin = identityService.newUser(ADMINISTRATOR);
            identityService.saveUser(admin);
            LOGGER.info("Created workflow user 'administrator'");
            GroupQuery gq = identityService.createGroupQuery();
            for (Group group : gq.list()) {
                identityService.createMembership(ADMINISTRATOR, group.getId());
                LOGGER.info("Created membership of user 'administrator' in group '" + group.getId() + "'");
            }
            LOGGER.info("Finished creating workflow user 'administrator' and its group membership.");
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.processEngine != null) {
            LOGGER.info("Shutting Activiti ProcessEngine down.");
            this.processEngine.close();
        }
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public HistoryService getHistoryService() {
        return this.processEngine.getHistoryService();
    }

    public TaskService getTaskService() {
        return this.processEngine.getTaskService();
    }

    public IdentityService getIdentityService() {
        return this.processEngine.getIdentityService();
    }

    public FormService getFormService() {
        return this.processEngine.getFormService();
    }
}

