/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.wf;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.repo.sql.SqlRepositoryConfiguration;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

public class WfConfiguration {
    private static final transient Trace LOGGER = TraceManager.getTrace(WfConfiguration.class);
    private static final String WF_CONFIG_SECTION = "midpoint.workflow";
    private boolean enabled;
    private boolean activitiSchemaUpdate;
    private String database;
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String hibernateDialect;
    private boolean databaseIsEmbedded;
    private int processCheckInterval;

    void initialize(MidpointConfiguration masterConfig, SqlRepositoryConfiguration sqlConfig) {
        Configuration c = masterConfig.getConfiguration(WF_CONFIG_SECTION);
        this.enabled = c.getBoolean("enabled", false);
        this.activitiSchemaUpdate = c.getBoolean("activitiSchemaUpdate", false);
        this.jdbcDriver = c.getString("jdbcDriver", sqlConfig != null ? sqlConfig.getDriverClassName() : null);
        this.jdbcUrl = c.getString("jdbcUrl", sqlConfig != null ? sqlConfig.getJdbcUrl() : null);
        this.jdbcUser = c.getString("jdbcUser", sqlConfig != null ? sqlConfig.getJdbcUsername() : null);
        this.jdbcPassword = c.getString("jdbcPassword", sqlConfig != null ? sqlConfig.getJdbcPassword() : null);
        this.processCheckInterval = c.getInt("processCheckInterval", 30);
        this.hibernateDialect = sqlConfig != null ? sqlConfig.getHibernateDialect() : "";
        this.validate();
    }

    void validate() {
        this.notEmpty(this.jdbcDriver, "JDBC driver must be specified (either explicitly or in SQL repository configuration)");
        this.notEmpty(this.jdbcUrl, "JDBC URL must be specified (either explicitly or in SQL repository configuration).");
        this.notNull(this.jdbcUser, "JDBC user name must be specified (either explicitly or in SQL repository configuration).");
        this.notNull(this.jdbcPassword, "JDBC password must be specified (either explicitly or in SQL repository configuration).");
    }

    private void notEmpty(String value, String message) {
        if (StringUtils.isEmpty((String)value)) {
            throw new SystemException(message);
        }
    }

    private void notNull(String value, String message) {
        if (value == null) {
            throw new SystemException(message);
        }
    }

    private void mustBeTrue(boolean condition, String message) {
        if (!condition) {
            throw new SystemException(message);
        }
    }

    private void mustBeFalse(boolean condition, String message) {
        if (condition) {
            throw new SystemException(message);
        }
    }

    public boolean isActivitiSchemaUpdate() {
        return this.activitiSchemaUpdate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public int getProcessCheckInterval() {
        return this.processCheckInterval;
    }
}

