/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server.impl;

import java.net.ServerSocket;
import java.util.concurrent.CountDownLatch;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.ConnectorInfoManagerFactoryImpl;
import org.identityconnectors.framework.server.ConnectorServer;
import org.identityconnectors.framework.server.impl.ConnectionListener;

public class ConnectorServerImpl
extends ConnectorServer {
    private ConnectionListener _listener;
    private CountDownLatch _stopLatch;

    public boolean isStarted() {
        return this._listener != null;
    }

    public void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("Server is already running.");
        }
        if (this.getPort() == 0) {
            throw new IllegalStateException("Port must be set prior to starting server.");
        }
        if (this.getKeyHash() == null) {
            throw new IllegalStateException("Key hash must be set prior to starting server.");
        }
        ConnectorInfoManagerFactoryImpl factory = (ConnectorInfoManagerFactoryImpl)ConnectorInfoManagerFactory.getInstance();
        factory.getLocalManager(this.getBundleURLs(), this.getBundleParentClassLoader());
        ServerSocket socket = this.createServerSocket();
        ConnectionListener listener = new ConnectionListener(this, socket);
        listener.start();
        this._stopLatch = new CountDownLatch(1);
        this._listener = listener;
    }

    private ServerSocket createServerSocket() {
        try {
            ServerSocketFactory factory = this.getUseSSL() ? this.createSSLServerSocketFactory() : ServerSocketFactory.getDefault();
            ServerSocket rv = this.getIfAddress() == null ? factory.createServerSocket(this.getPort(), this.getMaxConnections()) : factory.createServerSocket(this.getPort(), this.getMaxConnections(), this.getIfAddress());
            return rv;
        }
        catch (Exception e) {
            throw ConnectorException.wrap(e);
        }
    }

    private ServerSocketFactory createSSLServerSocketFactory() throws Exception {
        KeyManager[] keyManagers = null;
        if (this.getKeyManagers().size() > 0) {
            keyManagers = this.getKeyManagers().toArray(new KeyManager[0]);
        }
        if (keyManagers == null) {
            return SSLServerSocketFactory.getDefault();
        }
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagers, null, null);
        return context.getServerSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this._listener != null) {
            try {
                this._listener.shutdown();
            }
            finally {
                this._stopLatch.countDown();
            }
            this._stopLatch = null;
            this._listener = null;
        }
        ConnectorFacadeFactory.getInstance().dispose();
    }

    public void awaitStop() throws InterruptedException {
        this._stopLatch.await();
    }
}

