/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.core.Prop;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.item.Value;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class FNInfo
extends FuncCall {
    public FNInfo(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(final QueryContext ctx) throws QueryException {
        switch (this.def) {
            case ERROR: {
                int al = this.expr.length;
                if (al == 0) {
                    Err.FUNERR1.thrw(this.input, new Object[0]);
                }
                String code = Err.FUNERR1.code();
                String msg = Err.FUNERR1.desc;
                Item it = this.expr[0].item(ctx, this.input);
                if (it == null) {
                    if (al == 1) {
                        Err.XPEMPTY.thrw(this.input, this.desc());
                    }
                } else {
                    code = Token.string(((QNm)this.checkType(it, AtomType.QNM)).ln());
                }
                if (al > 1) {
                    msg = Token.string(this.checkEStr(this.expr[1], ctx));
                }
                Value val = al > 2 ? this.expr[2].value(ctx) : null;
                QueryException ex = new QueryException(this.input, code, val, msg, new Object[0]);
                throw ex;
            }
            case TRACE: {
                return new Iter(){
                    final Iter ir;
                    final byte[] s;
                    {
                        this.ir = FNInfo.this.expr[0].iter(queryContext);
                        this.s = FNInfo.this.checkEStr(FNInfo.this.expr[1], queryContext);
                    }

                    @Override
                    public Item next() throws QueryException {
                        Item i = this.ir.next();
                        if (i != null) {
                            TokenBuilder tb = new TokenBuilder(this.s);
                            if (this.s.length != 0) {
                                tb.add(": ");
                            }
                            tb.add(i.toString());
                            if (Prop.gui || !ctx.context.user.perm(8)) {
                                ctx.evalInfo(tb.finish());
                            } else {
                                Util.errln(tb, new Object[0]);
                            }
                        }
                        return i;
                    }
                };
            }
            case ENVARS: {
                ItemCache ic = new ItemCache();
                Object[] objectArray = System.getenv().keySet().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object k = objectArray[n2];
                    ic.add(Str.get(k));
                    ++n2;
                }
                return ic;
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case ENVAR: {
                String e = System.getenv(Token.string(this.checkEStr(this.expr[0], ctx)));
                return e != null ? Str.get(e) : null;
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Expr cmp(QueryContext ctx) {
        if (this.def == Function.TRACE) {
            this.type = this.expr[0].type();
        }
        return this;
    }

    @Override
    public boolean vacuous() {
        return this.def == Function.ERROR;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 && (this.def == Function.ENVAR || this.def == Function.ENVARS) || u == Expr.Use.CTX && (this.def == Function.ERROR || this.def == Function.TRACE) || super.uses(u);
    }
}

