/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Simple;
import org.basex.query.ft.FTExpr;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.FTNode;
import org.basex.query.item.Str;
import org.basex.query.iter.FTIter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FTIndexAccess
extends Simple {
    private final FTExpr ftexpr;
    private final IndexContext ictx;

    public FTIndexAccess(InputInfo ii, FTExpr ex, IndexContext ic) {
        super(ii);
        this.ftexpr = ex;
        this.ictx = ic;
    }

    @Override
    public NodeIter iter(final QueryContext ctx) throws QueryException {
        final FTIter ir = this.ftexpr.iter(ctx);
        return new NodeIter(){

            @Override
            public ANode next() throws QueryException {
                FTNode it = ir.next();
                if (it != null) {
                    if (ctx.ftpos != null) {
                        ctx.ftpos.add(it.data, it.pre, it.all);
                    }
                    it.score();
                    it.all = null;
                }
                return it;
            }
        };
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.ftexpr.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.ftexpr.count(v);
    }

    @Override
    public boolean removable(Var v) {
        return this.ftexpr.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        this.ftexpr.remove(v);
        return this;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.DATA, Token.token(this.ictx.data.meta.name)});
        this.ftexpr.plan(ser);
        ser.closeElement();
    }

    @Override
    public boolean iterable() {
        return this.ictx.iterable;
    }

    @Override
    public String toString() {
        return Function.DBFULLTEXT.get(this.input, Str.get(this.ictx.data.meta.name), this.ftexpr).toString();
    }
}

