/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.UserFunc;
import org.basex.query.item.QNm;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public abstract class UserFuncCall
extends Arr {
    final QNm name;
    UserFunc func;

    public UserFuncCall(InputInfo ii, QNm nm, Expr ... arg) {
        super(ii, arg);
        this.name = nm;
    }

    public void init(UserFunc f) {
        this.func = f;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        super.comp(ctx);
        this.func.comp(ctx);
        if (this.func.expr.value() && this.values() && !this.func.uses(Expr.Use.CTX)) {
            int a = 0;
            while (a < this.expr.length) {
                this.func.args[a].bind(this.expr[a], ctx);
                ++a;
            }
            ctx.compInfo("inlining function %(...)", new Object[]{this.func.name.atom()});
            return this.func.value(ctx);
        }
        this.type = this.func.type();
        return this;
    }

    int addArgs(QueryContext ctx, Var[] vs) {
        int s = ctx.vars.size();
        Var[] varArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            Var v = varArray[n2];
            ctx.vars.add(v);
            ++n2;
        }
        return s;
    }

    Var[] args(QueryContext ctx) throws QueryException {
        int al = this.expr.length;
        Var[] args = new Var[al];
        int a = 0;
        while (a < al) {
            args[a] = this.func.args[a].bind(this.expr[a].value(ctx), ctx).copy();
            ++a;
        }
        return args;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.UPD ? this.func.updating : super.uses(u);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.NAM, Token.token(this.toString())});
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            e.plan(ser);
            ++n2;
        }
        ser.closeElement();
    }

    @Override
    public String desc() {
        return "Function";
    }

    @Override
    public String toString() {
        return new TokenBuilder(this.name.atom()).add("(").add(this.toString(", ")).add(")").toString();
    }

    public final class Continuation
    extends RuntimeException {
        private final Var[] args;

        public Continuation(Var[] arg) {
            this.args = arg;
        }

        Expr getFunc() {
            return UserFuncCall.this.func;
        }

        Var[] getArgs() {
            return this.args;
        }

        @Override
        public synchronized Continuation fillInStackTrace() {
            return this;
        }
    }
}

