/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.data.FTPos;
import org.basex.io.serial.Serializer;
import org.basex.util.Atts;
import org.basex.util.Token;

public class BuilderSerializer
extends Serializer {
    private byte[] tag;
    private boolean open;
    private final Atts att = new Atts();
    private final Builder build;

    public BuilderSerializer(Builder b) {
        this.build = b;
    }

    @Override
    public final void text(byte[] b, FTPos ftp) throws IOException {
        this.text(b);
    }

    @Override
    public final void text(byte[] b) throws IOException {
        this.finish();
        this.build.text(b);
    }

    @Override
    protected void start(byte[] t) throws IOException {
        this.tag = t;
        this.open = true;
    }

    @Override
    public final void pi(byte[] n, byte[] v) throws IOException {
        this.build.pi(Token.concat(n, new byte[]{32}, v));
    }

    @Override
    public final void item(byte[] b) throws IOException {
        this.text(b);
    }

    @Override
    protected final void finish() throws IOException {
        if (this.open) {
            this.build.startElem(this.tag, this.att);
            this.att.reset();
            this.open = false;
        }
    }

    @Override
    protected final void empty() throws IOException {
        if (this.open) {
            this.build.emptyElem(this.tag, this.att);
            this.open = false;
        } else {
            this.close(this.tag);
        }
        this.tag = null;
        this.att.reset();
    }

    @Override
    public final void comment(byte[] b) throws IOException {
        this.build.comment(b);
    }

    @Override
    protected final void close(byte[] t) throws IOException {
        this.build.endElem(t);
        this.tag = null;
    }

    @Override
    public final void attribute(byte[] n, byte[] v) throws IOException {
        if (Token.startsWith(n, Token.XMLNS)) {
            if (n.length == 5) {
                this.build.startNS(Token.EMPTY, v);
            } else if (n[5] == 58) {
                this.build.startNS(Token.substring(n, 6), v);
            } else {
                this.att.add(n, v);
            }
        } else {
            this.att.add(n, v);
        }
    }

    @Override
    protected void openDoc(byte[] name) throws IOException {
        this.build.startDoc(name);
    }

    @Override
    protected final void closeDoc() throws IOException {
        this.build.endDoc();
    }

    @Override
    public final void openResult() throws IOException {
    }

    @Override
    public final void closeResult() throws IOException {
    }

    @Override
    protected final void cls() throws IOException {
    }
}

