/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.Text;
import org.basex.data.StatsKey;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenSet;

public final class Names
extends TokenSet {
    private StatsKey[] stat;
    private final int cats;

    public Names(int c) {
        this.stat = new StatsKey[8];
        this.cats = c;
    }

    public Names(DataInput in, int c) throws IOException {
        super(in);
        this.stat = new StatsKey[this.keys.length];
        this.cats = c;
        int s = 1;
        while (s < this.size) {
            this.stat[s] = new StatsKey(in, c);
            ++s;
        }
    }

    public void init() {
        int s = 1;
        while (s < this.size) {
            this.stat[s] = new StatsKey(this.cats);
            ++s;
        }
    }

    public int index(byte[] k, byte[] v, boolean st) {
        int s = Math.abs(this.add(k));
        if (st) {
            if (this.stat[s] == null) {
                this.stat[s] = new StatsKey(this.cats);
            }
            if (v != null) {
                this.stat[s].add(v);
            }
            ++this.stat[s].counter;
        }
        return s;
    }

    public void index(int i, byte[] v) {
        this.stat[i].add(v);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        int s = 1;
        while (s < this.size) {
            if (this.stat[s] == null) {
                this.stat[s] = new StatsKey(this.cats);
            }
            this.stat[s].finish(out);
            ++s;
        }
    }

    public StatsKey stat(int id) {
        return this.stat[id];
    }

    public byte[] info() {
        double[] tl = new double[this.size];
        int len = 0;
        tl[0] = 0.0;
        int i = 1;
        while (i < this.size) {
            if (len < this.keys[i].length) {
                len = this.keys[i].length;
            }
            if (this.stat[i] != null) {
                tl[i] = this.stat[i].counter;
            }
            ++i;
        }
        len += 2;
        int[] ids = Array.createOrder(tl, false);
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: Hash" + Text.NL);
        tb.add("- Entries: " + (this.size - 1) + Text.NL);
        int i2 = 0;
        while (i2 < this.size - 1) {
            int s = ids[i2];
            if (this.stat[s] != null) {
                byte[] key = this.keys[s];
                tb.add("  ");
                tb.add(key);
                int j = 0;
                while (j < len - key.length) {
                    tb.add(32);
                    ++j;
                }
                tb.add(this.stat[s] + Text.NL);
            }
            ++i2;
        }
        return tb.finish();
    }

    @Override
    protected void rehash() {
        super.rehash();
        this.stat = Arrays.copyOf(this.stat, this.size << 1);
    }
}

