/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.basex.core.Prop;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public abstract class AProp {
    protected final HashMap<String, Object> props;
    private final String filename;

    public AProp(String prop) {
        TokenBuilder err;
        StringList read;
        block38: {
            this.props = new HashMap();
            this.filename = String.valueOf(Prop.HOME) + ".basex" + prop;
            try {
                Field[] fieldArray = this.getClass().getFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    Object obj = f.get(null);
                    if (obj instanceof Object[]) {
                        Object[] arr = (Object[])obj;
                        this.props.put(arr[0].toString(), arr[1]);
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                Util.notexpected(ex);
            }
            if (prop == null) {
                return;
            }
            read = new StringList();
            err = new TokenBuilder();
            File file = new File(this.filename);
            if (!file.exists()) {
                err.addExt("Saving properties in \"%\"..." + Prop.NL, this.filename);
            } else {
                BufferedReader br = null;
                try {
                    try {
                        String line;
                        br = new BufferedReader(new FileReader(file));
                        while ((line = br.readLine()) != null) {
                            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                            int d = line.indexOf(61);
                            if (d < 0) {
                                err.addExt("%: \"%\" ignored. " + Prop.NL, this.filename, line);
                                continue;
                            }
                            String val = line.substring(d + 1).trim();
                            String key = line.substring(0, d).trim().toUpperCase();
                            int num = 0;
                            int s = 0;
                            while (s < key.length()) {
                                if (Character.isDigit(key.charAt(s))) {
                                    num = Integer.parseInt(key.substring(s));
                                    key = key.substring(0, s);
                                    break;
                                }
                                ++s;
                            }
                            read.add(key);
                            Object entry = this.props.get(key);
                            if (entry == null) {
                                err.addExt("%: \"%\" not found. " + Prop.NL, this.filename, key);
                                continue;
                            }
                            if (entry instanceof String) {
                                this.props.put(key, val);
                                continue;
                            }
                            if (entry instanceof Integer) {
                                this.props.put(key, Integer.parseInt(val));
                                continue;
                            }
                            if (entry instanceof Boolean) {
                                this.props.put(key, Boolean.parseBoolean(val));
                                continue;
                            }
                            if (entry instanceof String[]) {
                                if (num == 0) {
                                    this.props.put(key, new String[Integer.parseInt(val)]);
                                    continue;
                                }
                                ((String[])entry)[num - 1] = val;
                                continue;
                            }
                            if (!(entry instanceof int[])) continue;
                            ((int[])entry)[num] = Integer.parseInt(val);
                        }
                    }
                    catch (Exception ex) {
                        err.addExt("% could not be parsed." + Prop.NL, this.filename);
                        Util.debug(ex);
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block38;
                    }
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            if (err.size() == 0) {
                boolean ok = true;
                Field[] fieldArray = this.getClass().getFields();
                int n = fieldArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Field f = fieldArray[n3];
                    Object obj = f.get(null);
                    if (obj instanceof Object[]) {
                        String key = ((Object[])obj)[0].toString();
                        ok &= read.contains(key);
                    }
                    ++n3;
                }
                if (!ok) {
                    err.addExt("Saving properties in \"%\"..." + Prop.NL, this.filename);
                }
            }
        }
        catch (IllegalAccessException ex) {
            Util.notexpected(ex);
        }
        if (err.size() != 0) {
            Util.err(err.toString(), new Object[0]);
            this.write();
        }
    }

    public final synchronized void write() {
        block39: {
            StringBuilder user;
            File file;
            block38: {
                file = new File(this.filename);
                user = new StringBuilder();
                BufferedReader br = null;
                try {
                    try {
                        if (file.exists()) {
                            String line;
                            br = new BufferedReader(new FileReader(file));
                            while ((line = br.readLine()) != null) {
                                if (line.equals("# User defined section")) break;
                            }
                            while ((line = br.readLine()) != null) {
                                user.append(line).append(Prop.NL);
                            }
                        }
                    }
                    catch (Exception ex) {
                        Util.debug(ex);
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block38;
                    }
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            BufferedWriter bw = null;
            try {
                try {
                    bw = new BufferedWriter(new FileWriter(file));
                    bw.write(String.valueOf(Prop.PROPHEADER) + Prop.NL);
                    Field[] fieldArray = this.getClass().getFields();
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field f = fieldArray[n2];
                        Object obj = f.get(null);
                        if (obj instanceof Object[]) {
                            int i;
                            String key = ((Object[])obj)[0].toString();
                            Object val = this.props.get(key);
                            if (val instanceof String[]) {
                                String[] str = (String[])val;
                                bw.write(String.valueOf(key) + " = " + str.length + Prop.NL);
                                i = 0;
                                while (i < str.length) {
                                    if (str[i] != null) {
                                        bw.write(String.valueOf(key) + (i + 1) + " = " + str[i] + Prop.NL);
                                    }
                                    ++i;
                                }
                            } else if (val instanceof int[]) {
                                int[] num = (int[])val;
                                i = 0;
                                while (i < num.length) {
                                    bw.write(String.valueOf(key) + i + " = " + num[i] + Prop.NL);
                                    ++i;
                                }
                            } else {
                                bw.write(String.valueOf(key) + " = " + val + Prop.NL);
                            }
                        }
                        ++n2;
                    }
                    bw.write(String.valueOf(Prop.NL) + "# User defined section" + Prop.NL);
                    bw.write(user.toString());
                }
                catch (Exception ex) {
                    Util.errln("% could not be written.", this.filename);
                    Util.debug(ex);
                    if (bw == null) break block39;
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public final Object get(String key) {
        return this.props.get(key);
    }

    public final String get(Object[] key) {
        return this.get(key, String.class).toString();
    }

    public final int num(Object[] key) {
        return (Integer)this.get(key, Integer.class);
    }

    public final boolean is(Object[] key) {
        return (Boolean)this.get(key, Boolean.class);
    }

    public final String[] strings(Object[] key) {
        return (String[])this.get(key, String[].class);
    }

    public final int[] nums(Object[] key) {
        return (int[])this.get(key, int[].class);
    }

    public final void set(Object[] key, String val) {
        this.set(key, val, String.class);
    }

    public final void set(Object[] key, int val) {
        this.set(key, val, Integer.class);
    }

    public final void set(Object[] key, boolean val) {
        this.set(key, val, Boolean.class);
    }

    public final void set(Object[] key, String[] val) {
        this.set(key, val, String[].class);
    }

    public final void set(Object[] key, int[] val) {
        this.set(key, val, int[].class);
    }

    public final void set(String key, Object val) {
        this.props.put(key, val);
        this.finish();
    }

    public final boolean invert(Object[] key) {
        boolean val = !this.is(key);
        this.set(key, val);
        return val;
    }

    public final boolean sameAs(Object[] key, Object val) {
        return this.props.get(key[0].toString()).equals(val);
    }

    public final String similar(String key) {
        byte[] name = Token.token(key);
        Levenshtein ls = new Levenshtein();
        for (String prop : this.props.keySet()) {
            if (!ls.similar(name, Token.token(prop), 0)) continue;
            return prop;
        }
        return null;
    }

    private Object get(Object[] key, Class<?> c) {
        Object entry = this.props.get(key[0].toString());
        if (entry == null) {
            throw Util.notexpected("Property " + key[0] + " not defined.");
        }
        Class<?> cc = entry.getClass();
        if (c != cc) {
            Util.notexpected("Property '" + key[0] + "' is a " + Util.name(cc));
        }
        return entry;
    }

    private boolean set(Object[] key, Object val, Class<?> c) {
        Object old = this.get(key, c);
        boolean eq = old.equals(val);
        this.props.put(key[0].toString(), val);
        this.finish();
        return !eq;
    }

    protected void finish() {
    }

    public String toString() {
        return String.valueOf(Util.name(this)) + this.props;
    }
}

