/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util.xml;

import org.activiti.engine.impl.util.xml.Element;
import org.xml.sax.SAXParseException;

public class Problem {
    protected String errorMessage;
    protected String resource;
    protected int line;
    protected int column;

    public Problem(SAXParseException e, String resource) {
        for (Throwable exception = e; exception != null; exception = exception.getCause()) {
            this.errorMessage = this.errorMessage == null ? exception.getMessage() : this.errorMessage + ": " + exception.getMessage();
        }
        this.resource = resource;
        this.line = e.getLineNumber();
        this.column = e.getColumnNumber();
    }

    public Problem(String errorMessage, String resourceName, Element element) {
        this.errorMessage = errorMessage;
        this.resource = resourceName;
        if (element != null) {
            this.line = element.getLine();
            this.column = element.getColumn();
        }
    }

    public String toString() {
        return this.errorMessage + (this.resource != null ? " | " + this.resource : "") + " | line " + this.line + " | column " + this.column;
    }
}

