/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.rules;

import java.util.Map;
import java.util.logging.Logger;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.deploy.Deployer;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;

public class RulesDeployer
implements Deployer {
    private static Logger log = Logger.getLogger(RulesDeployer.class.getName());

    public void deploy(DeploymentEntity deployment) {
        KnowledgeBuilder knowledgeBuilder = null;
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        Map<String, ResourceEntity> resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            log.info("Processing resource " + resourceName);
            if (!resourceName.endsWith(".drl")) continue;
            if (knowledgeBuilder == null) {
                knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            }
            ResourceEntity resourceEntity = resources.get(resourceName);
            byte[] resourceBytes = resourceEntity.getBytes();
            Resource droolsResource = ResourceFactory.newByteArrayResource((byte[])resourceBytes);
            knowledgeBuilder.add(droolsResource, ResourceType.DRL);
        }
        if (knowledgeBuilder != null) {
            KnowledgeBase knowledgeBase = knowledgeBuilder.newKnowledgeBase();
            deploymentCache.addKnowledgeBase(deployment.getId(), knowledgeBase);
        }
    }
}

