/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.CommentManager;
import org.activiti.engine.impl.util.ClockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;

    public DeleteAttachmentCmd(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        CommentManager commentManager;
        AttachmentEntity attachment = commandContext.getDbSqlSession().selectById(AttachmentEntity.class, this.attachmentId);
        commandContext.getDbSqlSession().delete(AttachmentEntity.class, this.attachmentId);
        if (attachment.getTaskId() != null && (commentManager = commandContext.getCommentManager()).isHistoryEnabled()) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = new CommentEntity();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(ClockUtil.getCurrentTime());
            comment.setAction("DeleteAttachment");
            comment.setMessage(attachment.getName());
            comment.setTaskId(attachment.getTaskId());
            commentManager.insert(comment);
        }
        return null;
    }
}

