/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.schema;

import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.Definition;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismConstants;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.prism.schema.SchemaDefinitionFactory;
import com.evolveum.midpoint.prism.xml.DynamicNamespacePrefixMapper;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaToDomProcessor {
    private static final Trace LOGGER = TraceManager.getTrace(SchemaToDomProcessor.class);
    public static final String RESOURCE_OBJECT_CLASS = "ResourceObjectClass";
    private static final String MAX_OCCURS_UNBOUNDED = "unbounded";
    private boolean attributeQualified = false;
    private PrismContext prismContext;
    private DynamicNamespacePrefixMapper namespacePrefixMapper;
    private PrismSchema schema;
    private Element rootXsdElement;
    private Set<String> importNamespaces = new HashSet<String>();
    private Document document;

    SchemaToDomProcessor() {
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    void setAttributeQualified(boolean attributeQualified) {
        this.attributeQualified = attributeQualified;
    }

    public DynamicNamespacePrefixMapper getNamespacePrefixMapper() {
        return this.namespacePrefixMapper;
    }

    public void setNamespacePrefixMapper(DynamicNamespacePrefixMapper namespacePrefixMapper) {
        this.namespacePrefixMapper = namespacePrefixMapper;
    }

    private SchemaDefinitionFactory getDefinitionFactory() {
        return this.prismContext.getDefinitionFactory();
    }

    private String getNamespace() {
        return this.schema.getNamespace();
    }

    private boolean isMyNamespace(QName qname) {
        return this.getNamespace().equals(qname.getNamespaceURI());
    }

    Document parseSchema(PrismSchema schema) throws SchemaException {
        if (schema == null) {
            throw new IllegalArgumentException("Schema can't be null.");
        }
        this.schema = schema;
        try {
            this.init();
            Collection<ComplexTypeDefinition> complexTypes = schema.getDefinitions(ComplexTypeDefinition.class);
            for (ComplexTypeDefinition complexTypeDefinition : complexTypes) {
                this.addComplexTypeDefinition(complexTypeDefinition, this.document.getDocumentElement());
            }
            Collection<Definition> definitions = schema.getDefinitions();
            for (Definition definition : definitions) {
                if (definition instanceof PrismContainerDefinition) {
                    this.addContainerDefinition((PrismContainerDefinition)definition, this.document.getDocumentElement(), this.document.getDocumentElement());
                    continue;
                }
                if (definition instanceof PrismPropertyDefinition) {
                    this.addPropertyDefinition((PrismPropertyDefinition)definition, this.document.getDocumentElement());
                    continue;
                }
                if (definition instanceof ComplexTypeDefinition) continue;
                throw new IllegalArgumentException("Encountered unsupported definition in schema: " + definition);
            }
            this.addImports();
        }
        catch (Exception ex) {
            throw new SchemaException("Couldn't parse schema, reason: " + ex.getMessage(), (Throwable)ex);
        }
        return this.document;
    }

    private void addContainerDefinition(PrismContainerDefinition definition, Element elementParent, Element complexTypeParent) {
        ComplexTypeDefinition complexTypeDefinition = definition.getComplexTypeDefinition();
        if (complexTypeDefinition != null && this.schema.findComplexTypeDefinition(complexTypeDefinition.getTypeName()) == null && this.getNamespace().equals(complexTypeDefinition.getTypeName().getNamespaceURI())) {
            this.addComplexTypeDefinition(complexTypeDefinition, complexTypeParent);
        }
        Element elementElement = this.addElementDefinition(definition.getName(), definition.getTypeName(), definition.getMinOccurs(), definition.getMaxOccurs(), elementParent);
        if (complexTypeDefinition == null || !complexTypeDefinition.isContainerMarker()) {
            this.addAnnotationToDefinition(elementElement, PrismConstants.A_PROPERTY_CONTAINER);
        }
    }

    private void addPropertyDefinition(PrismPropertyDefinition definition, Element parent) {
        Element property = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "element"));
        parent.appendChild(property);
        String attrNamespace = definition.getName().getNamespaceURI();
        if (attrNamespace != null && attrNamespace.equals(this.getNamespace())) {
            this.setAttribute(property, "name", definition.getName().getLocalPart());
            this.setQNameAttribute(property, "type", definition.getTypeName());
        } else {
            this.setQNameAttribute(property, "ref", definition.getName());
        }
        if (definition.getMinOccurs() != 1) {
            this.setAttribute(property, "minOccurs", Integer.toString(definition.getMinOccurs()));
        }
        if (definition.getMaxOccurs() != 1) {
            String maxOccurs = definition.getMaxOccurs() == -1 ? MAX_OCCURS_UNBOUNDED : Integer.toString(definition.getMaxOccurs());
            this.setAttribute(property, "maxOccurs", maxOccurs);
        }
        Element annotation = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "annotation"));
        property.appendChild(annotation);
        Element appinfo = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "appinfo"));
        annotation.appendChild(appinfo);
        this.addCommonDefinitionAnnotations(definition, appinfo);
        if (definition.isIgnored()) {
            this.addAnnotation(PrismConstants.A_IGNORE, "true", appinfo);
        }
        if (!(definition.canCreate() && definition.canRead() && definition.canUpdate())) {
            if (definition.canCreate()) {
                this.addAnnotation(PrismConstants.A_ACCESS, "create", appinfo);
            }
            if (definition.canRead()) {
                this.addAnnotation(PrismConstants.A_ACCESS, "read", appinfo);
            }
            if (definition.canUpdate()) {
                this.addAnnotation(PrismConstants.A_ACCESS, "update", appinfo);
            }
        }
        if (definition.isIndexed() != null) {
            this.addAnnotation(PrismConstants.A_INDEXED, XmlTypeConverter.toXmlTextContent(definition.isIndexed(), PrismConstants.A_INDEXED), appinfo);
        }
        if (!appinfo.hasChildNodes()) {
            property.removeChild(annotation);
        }
        SchemaDefinitionFactory definitionFactory = this.getDefinitionFactory();
        definitionFactory.addExtraPropertyAnnotations(definition, appinfo, this);
    }

    private void addReferenceDefinition(PrismReferenceDefinition definition, Element parent) {
        Element property = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "element"));
        parent.appendChild(property);
        String attrNamespace = definition.getName().getNamespaceURI();
        if (attrNamespace != null && attrNamespace.equals(this.getNamespace())) {
            this.setAttribute(property, "name", definition.getName().getLocalPart());
            this.setQNameAttribute(property, "type", definition.getTypeName());
        } else {
            this.setQNameAttribute(property, "ref", definition.getName());
        }
        if (definition.getCompositeObjectElementName() == null) {
            this.setMultiplicityAttribute(property, "minOccurs", 0);
        }
        this.setMultiplicityAttribute(property, "maxOccurs", definition.getMaxOccurs());
        Element annotation = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "annotation"));
        property.appendChild(annotation);
        Element appinfo = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "appinfo"));
        annotation.appendChild(appinfo);
        this.addAnnotation(PrismConstants.A_OBJECT_REFERENCE, appinfo);
        if (definition.getTargetTypeName() != null) {
            this.addAnnotation(PrismConstants.A_OBJECT_REFERENCE_TARGET_TYPE, definition.getTargetTypeName(), appinfo);
        }
        if (definition.getCompositeObjectElementName() == null) {
            return;
        }
        property = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "element"));
        parent.appendChild(property);
        QName elementName = definition.getCompositeObjectElementName();
        attrNamespace = elementName.getNamespaceURI();
        if (attrNamespace != null && attrNamespace.equals(this.getNamespace())) {
            this.setAttribute(property, "name", elementName.getLocalPart());
            this.setQNameAttribute(property, "type", definition.getTargetTypeName());
        } else {
            this.setQNameAttribute(property, "ref", elementName);
        }
        this.setMultiplicityAttribute(property, "minOccurs", 0);
        this.setMultiplicityAttribute(property, "maxOccurs", definition.getMaxOccurs());
        annotation = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "annotation"));
        property.appendChild(annotation);
        appinfo = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "appinfo"));
        annotation.appendChild(appinfo);
        this.addAnnotation(PrismConstants.A_OBJECT_REFERENCE, definition.getName(), appinfo);
        SchemaDefinitionFactory definitionFactory = this.getDefinitionFactory();
        definitionFactory.addExtraReferenceAnnotations(definition, appinfo, this);
    }

    private Element addElementDefinition(QName name, QName typeName, int minOccurs, int maxOccurs, Element parent) {
        Element elementDef = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "element"));
        parent.appendChild(elementDef);
        if (this.isMyNamespace(name)) {
            this.setAttribute(elementDef, "name", name.getLocalPart());
            if (typeName.equals(DOMUtil.XSD_ANY)) {
                this.addSequenceXsdAnyDefinition(elementDef);
            } else {
                this.setQNameAttribute(elementDef, "type", typeName);
            }
        } else {
            this.setAttribute(elementDef, "ref", name);
            if (typeName != null) {
                this.addAnnotationToDefinition(elementDef, PrismConstants.A_TYPE, typeName);
            }
        }
        this.setMultiplicityAttribute(elementDef, "minOccurs", minOccurs);
        this.setMultiplicityAttribute(elementDef, "maxOccurs", maxOccurs);
        return elementDef;
    }

    private void addSequenceXsdAnyDefinition(Element elementDef) {
        Element complexContextElement = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "complexType"));
        elementDef.appendChild(complexContextElement);
        Element sequenceElement = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "sequence"));
        complexContextElement.appendChild(sequenceElement);
        this.addXsdAnyDefinition(sequenceElement);
    }

    private void addXsdAnyDefinition(Element elementDef) {
        Element anyElement = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "any"));
        elementDef.appendChild(anyElement);
        this.setAttribute(anyElement, "namespace", "##other");
        this.setAttribute(anyElement, "minOccurs", "0");
        this.setAttribute(anyElement, "maxOccurs", MAX_OCCURS_UNBOUNDED);
        this.setAttribute(anyElement, "processContents", "lax");
    }

    private Element addComplexTypeDefinition(ComplexTypeDefinition definition, Element parent) {
        if (definition == null) {
            return null;
        }
        if (definition.getTypeName() == null) {
            throw new UnsupportedOperationException("Anonymous complex types as containers are not supported yet");
        }
        Element complexType = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "complexType"));
        parent.appendChild(complexType);
        this.setAttribute(complexType, "name", definition.getTypeName().getLocalPart());
        Element annotation = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "annotation"));
        complexType.appendChild(annotation);
        Element containingElement = complexType;
        if (definition.getSuperType() != null) {
            Element complexContent = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "complexContent"));
            complexType.appendChild(complexContent);
            Element extension = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "extension"));
            complexContent.appendChild(extension);
            this.setQNameAttribute(extension, "base", definition.getSuperType());
            containingElement = extension;
        }
        Element sequence = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "sequence"));
        containingElement.appendChild(sequence);
        List<ItemDefinition> definitions = definition.getDefinitions();
        for (ItemDefinition def : definitions) {
            if (def instanceof PrismPropertyDefinition) {
                this.addPropertyDefinition((PrismPropertyDefinition)def, sequence);
                continue;
            }
            if (def instanceof PrismContainerDefinition) {
                PrismContainerDefinition contDef = (PrismContainerDefinition)def;
                this.addContainerDefinition(contDef, sequence, parent);
                continue;
            }
            if (def instanceof PrismReferenceDefinition) {
                this.addReferenceDefinition((PrismReferenceDefinition)def, sequence);
                continue;
            }
            throw new IllegalArgumentException("Uknown definition " + def + "(" + def.getClass().getName() + ") in complex type definition " + def);
        }
        if (definition.isXsdAnyMarker()) {
            this.addXsdAnyDefinition(sequence);
        }
        Element appinfo = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "appinfo"));
        annotation.appendChild(appinfo);
        if (definition.isObjectMarker()) {
            this.addAnnotation(PrismConstants.A_OBJECT, definition.getDisplayName(), appinfo);
        } else if (definition.isContainerMarker()) {
            this.addAnnotation(PrismConstants.A_PROPERTY_CONTAINER, definition.getDisplayName(), appinfo);
        }
        this.addCommonDefinitionAnnotations(definition, appinfo);
        SchemaDefinitionFactory definitionFactory = this.getDefinitionFactory();
        definitionFactory.addExtraComplexTypeAnnotations(definition, appinfo, this);
        if (!appinfo.hasChildNodes()) {
            complexType.removeChild(annotation);
        }
        return complexType;
    }

    private void addCommonDefinitionAnnotations(Definition definition, Element appinfoElement) {
        if (definition.getDisplayName() != null) {
            this.addAnnotation(PrismConstants.A_DISPLAY_NAME, definition.getDisplayName(), appinfoElement);
        }
        if (definition.getHelp() != null) {
            this.addAnnotation(PrismConstants.A_HELP, definition.getDisplayName(), appinfoElement);
        }
    }

    public Element addAnnotation(QName qname, String value, Element parent) {
        Element annotation = this.createElement(qname);
        parent.appendChild(annotation);
        if (value != null) {
            annotation.setTextContent(value);
        }
        return annotation;
    }

    public Element addAnnotation(QName qname, Element parent) {
        Element annotation = this.createElement(qname);
        parent.appendChild(annotation);
        return annotation;
    }

    public Element addAnnotation(QName qname, QName value, Element parent) {
        Element annotation = this.createElement(qname);
        parent.appendChild(annotation);
        if (value != null) {
            DOMUtil.setQNameValue((Element)annotation, (QName)value);
        }
        return annotation;
    }

    private void addAnnotationToDefinition(Element definitionElement, QName qname) {
        this.addAnnotationToDefinition(definitionElement, qname, null);
    }

    private void addAnnotationToDefinition(Element definitionElement, QName qname, QName value) {
        Element annotationElement = this.getOrCreateElement(new QName("http://www.w3.org/2001/XMLSchema", "annotation"), definitionElement);
        Element appinfoElement = this.getOrCreateElement(new QName("http://www.w3.org/2001/XMLSchema", "appinfo"), annotationElement);
        if (value == null) {
            this.addAnnotation(qname, appinfoElement);
        } else {
            this.addAnnotation(qname, value, appinfoElement);
        }
    }

    private Element getOrCreateElement(QName qName, Element parentElement) {
        NodeList elements = parentElement.getElementsByTagNameNS(qName.getNamespaceURI(), qName.getLocalPart());
        if (elements.getLength() == 0) {
            Element element = this.createElement(qName);
            Element refChild = DOMUtil.getFirstChildElement((Node)parentElement);
            parentElement.insertBefore(element, refChild);
            return element;
        }
        return (Element)elements.item(0);
    }

    public Element addRefAnnotation(QName qname, QName value, Element parent) {
        Element element = this.createElement(qname);
        parent.appendChild(element);
        DOMUtil.setQNameValue((Element)element, (QName)value);
        return element;
    }

    private void init() throws ParserConfigurationException {
        if (this.namespacePrefixMapper == null) {
            this.namespacePrefixMapper = this.prismContext.getSchemaRegistry().getNamespacePrefixMapper();
        }
        this.namespacePrefixMapper = this.namespacePrefixMapper.clone();
        this.namespacePrefixMapper.registerPrefixLocal(this.getNamespace(), "tns");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Using namespace prefix mapper to serialize schema:\n{}", (Object)DebugUtil.dump((Dumpable)this.namespacePrefixMapper));
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.document = db.newDocument();
        Element root = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
        this.document.appendChild(root);
        this.rootXsdElement = this.document.getDocumentElement();
        this.setAttribute(this.rootXsdElement, "targetNamespace", this.getNamespace());
        this.setAttribute(this.rootXsdElement, "elementFormDefault", "qualified");
        DOMUtil.setNamespaceDeclaration((Element)this.rootXsdElement, (String)"tns", (String)this.getNamespace());
        if (this.attributeQualified) {
            this.setAttribute(this.rootXsdElement, "attributeFormDefault", "qualified");
        }
    }

    private Document createDocument(QName name) throws ParserConfigurationException {
        return this.document;
    }

    private Element createElement(QName qname) {
        QName qnameWithPrefix = this.namespacePrefixMapper.setQNamePrefix(qname);
        this.addToImport(qname.getNamespaceURI());
        if (this.rootXsdElement != null) {
            return DOMUtil.createElement((Document)this.document, (QName)qnameWithPrefix, (Element)this.rootXsdElement, (Element)this.rootXsdElement);
        }
        return DOMUtil.createElement((Document)this.document, (QName)qnameWithPrefix);
    }

    private void setAttribute(Element element, String attrName, String attrValue) {
        this.setAttribute(element, new QName("http://www.w3.org/2001/XMLSchema", attrName), attrValue);
    }

    private void setAttribute(Element element, String attrName, QName attrValue) {
        this.setAttribute(element, new QName("http://www.w3.org/2001/XMLSchema", attrName), attrValue);
    }

    private void setMultiplicityAttribute(Element element, String attrName, int attrValue) {
        if (attrValue == 1) {
            return;
        }
        if (attrValue < 0) {
            this.setAttribute(element, attrName, MAX_OCCURS_UNBOUNDED);
        } else {
            this.setAttribute(element, attrName, Integer.toString(attrValue));
        }
    }

    private void setAttribute(Element element, QName attr, String attrValue) {
        if (this.attributeQualified) {
            element.setAttributeNS(attr.getNamespaceURI(), attr.getLocalPart(), attrValue);
            this.addToImport(attr.getNamespaceURI());
        } else {
            element.setAttribute(attr.getLocalPart(), attrValue);
        }
    }

    private void setAttribute(Element element, QName attr, QName attrValue) {
        if (this.attributeQualified) {
            DOMUtil.setQNameAttribute((Element)element, (QName)attr, (QName)attrValue, (Element)this.rootXsdElement);
            this.addToImport(attr.getNamespaceURI());
        } else {
            DOMUtil.setQNameAttribute((Element)element, (String)attr.getLocalPart(), (QName)attrValue, (Element)this.rootXsdElement);
        }
    }

    private void setQNameAttribute(Element element, String attrName, QName value) {
        QName valueWithPrefix = this.namespacePrefixMapper.setQNamePrefix(value);
        DOMUtil.setQNameAttribute((Element)element, (String)attrName, (QName)valueWithPrefix, (Element)this.rootXsdElement);
        this.addToImport(value.getNamespaceURI());
    }

    private void addToImport(String namespace) {
        if (!this.importNamespaces.contains(namespace)) {
            this.importNamespaces.add(namespace);
        }
    }

    private void addImports() {
        for (String namespace : this.importNamespaces) {
            if ("http://www.w3.org/2001/XMLSchema".equals(namespace) || this.getNamespace().equals(namespace)) continue;
            this.rootXsdElement.insertBefore(this.createImport(namespace), this.rootXsdElement.getFirstChild());
        }
    }

    private Element createImport(String namespace) {
        Element element = this.createElement(new QName("http://www.w3.org/2001/XMLSchema", "import"));
        this.setAttribute(element, "namespace", namespace);
        return element;
    }
}

