/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.delta;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.io.File;

public class DiffUtil {
    public static <T extends Objectable> ObjectDelta<T> diff(PrismObject<T> oldObject, PrismObject<T> newObject) {
        if (oldObject == null) {
            if (newObject == null) {
                return null;
            }
            ObjectDelta objectDelta = new ObjectDelta(newObject.getCompileTimeClass(), ChangeType.ADD);
            objectDelta.setOid(newObject.getOid());
            objectDelta.setObjectToAdd(newObject);
            return objectDelta;
        }
        return oldObject.diff(newObject);
    }

    public static <T extends Objectable> ObjectDelta<T> diff(T oldObjectType, T newObjectType, Class<T> type, PrismContext prismContext) throws SchemaException {
        PrismObject oldObject = null;
        if (oldObjectType != null) {
            oldObject = oldObjectType.asPrismObject();
        }
        PrismObject newObject = null;
        if (newObjectType != null) {
            newObject = newObjectType.asPrismObject();
        }
        return DiffUtil.diff(oldObject, newObject);
    }

    public static <T extends Objectable> ObjectDelta<T> diff(String oldXml, String newXml, Class<T> type, PrismContext prismContext) throws SchemaException {
        PrismObject oldObject = null;
        if (oldXml != null) {
            oldObject = prismContext.parseObject(oldXml);
        }
        PrismObject newObject = null;
        if (newXml != null) {
            newObject = prismContext.parseObject(newXml);
        }
        return DiffUtil.diff(oldObject, newObject);
    }

    public static <T extends Objectable> ObjectDelta<T> diff(File oldXmlFile, File newXmlFile, Class<T> type, PrismContext prismContext) throws SchemaException {
        PrismObject oldObject = null;
        if (oldXmlFile != null) {
            oldObject = prismContext.getPrismDomProcessor().parseObject(oldXmlFile);
        }
        PrismObject newObject = null;
        if (newXmlFile != null) {
            newObject = prismContext.getPrismDomProcessor().parseObject(newXmlFile);
        }
        return DiffUtil.diff(oldObject, newObject);
    }
}

