/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserTemplateType;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@ForeignKey(name="fk_user_template")
public class RUserTemplate
extends RObject {
    @QueryAttribute
    private String name;
    private String propertyConstruction;
    private String accountConstruction;

    @Type(type="org.hibernate.type.TextType")
    @Column(nullable=true)
    public String getAccountConstruction() {
        return this.accountConstruction;
    }

    @Type(type="org.hibernate.type.TextType")
    @Column(nullable=true)
    public String getPropertyConstruction() {
        return this.propertyConstruction;
    }

    @Index(name="iUserTemplateName")
    @Column(name="objectName", unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAccountConstruction(String accountConstruction) {
        this.accountConstruction = accountConstruction;
    }

    public void setPropertyConstruction(String propertyConstruction) {
        this.propertyConstruction = propertyConstruction;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RUserTemplate that = (RUserTemplate)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.accountConstruction != null ? !this.accountConstruction.equals(that.accountConstruction) : that.accountConstruction != null) {
            return false;
        }
        return !(this.propertyConstruction != null ? !this.propertyConstruction.equals(that.propertyConstruction) : that.propertyConstruction != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.propertyConstruction != null ? this.propertyConstruction.hashCode() : 0);
        result = 31 * result + (this.accountConstruction != null ? this.accountConstruction.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RUserTemplate repo, UserTemplateType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        try {
            UserTemplateType holder;
            if (StringUtils.isNotEmpty((String)repo.getAccountConstruction())) {
                holder = RUtil.toJAXB(repo.getAccountConstruction(), UserTemplateType.class, prismContext);
                jaxb.getAccountConstruction().addAll(holder.getAccountConstruction());
            }
            if (StringUtils.isNotEmpty((String)repo.getPropertyConstruction())) {
                holder = RUtil.toJAXB(repo.getPropertyConstruction(), UserTemplateType.class, prismContext);
                jaxb.getPropertyConstruction().addAll(holder.getPropertyConstruction());
            }
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public static void copyFromJAXB(UserTemplateType jaxb, RUserTemplate repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        try {
            UserTemplateType template;
            if (!jaxb.getAccountConstruction().isEmpty()) {
                template = new UserTemplateType();
                template.getAccountConstruction().addAll(jaxb.getAccountConstruction());
                repo.setAccountConstruction(RUtil.toRepo(template, prismContext));
            }
            if (!jaxb.getPropertyConstruction().isEmpty()) {
                template = new UserTemplateType();
                template.getPropertyConstruction().addAll(jaxb.getPropertyConstruction());
                repo.setPropertyConstruction(RUtil.toRepo(template, prismContext));
            }
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public UserTemplateType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        UserTemplateType object = new UserTemplateType();
        RUtil.revive((Objectable)object, prismContext);
        RUserTemplate.copyToJAXB(this, object, prismContext);
        return object;
    }
}

