/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.servlet.ResponseIOException;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.EmptyRequestHandler;
import org.apache.wicket.request.handler.IPageRequestHandler;
import org.apache.wicket.request.handler.ListenerInvocationNotAllowedException;
import org.apache.wicket.request.handler.PageProvider;
import org.apache.wicket.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.handler.ErrorCodeRequestHandler;
import org.apache.wicket.request.mapper.StalePageException;
import org.apache.wicket.settings.IExceptionSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionMapper
implements IExceptionMapper {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionMapper.class);

    public IRequestHandler map(Exception e) {
        try {
            return this.internalMap(e);
        }
        catch (RuntimeException e2) {
            if (logger.isDebugEnabled()) {
                logger.error("An error occurred while handling a previous error: " + e2.getMessage(), (Throwable)e2);
            }
            logger.error("unexpected exception when handling another exception: " + e.getMessage(), (Throwable)e);
            return new ErrorCodeRequestHandler(500);
        }
    }

    private IRequestHandler internalMap(Exception e) {
        Application application = Application.get();
        if (this.isProcessingAjaxRequest()) {
            switch (application.getExceptionSettings().getAjaxErrorHandlingStrategy()) {
                case INVOKE_FAILURE_HANDLER: {
                    return new ErrorCodeRequestHandler(500);
                }
            }
        }
        if (e instanceof StalePageException) {
            return new RenderPageRequestHandler(new PageProvider(((StalePageException)e).getPage()));
        }
        if (e instanceof PageExpiredException) {
            return this.createPageRequestHandler(new PageProvider(Application.get().getApplicationSettings().getPageExpiredErrorPage()));
        }
        if (e instanceof AuthorizationException || e instanceof ListenerInvocationNotAllowedException) {
            return this.createPageRequestHandler(new PageProvider(Application.get().getApplicationSettings().getAccessDeniedPage()));
        }
        if (e instanceof ResponseIOException) {
            logger.error("Connection lost, give up responding.", (Throwable)e);
            return new EmptyRequestHandler();
        }
        IExceptionSettings.UnexpectedExceptionDisplay unexpectedExceptionDisplay = application.getExceptionSettings().getUnexpectedExceptionDisplay();
        logger.error("Unexpected error occurred", (Throwable)e);
        if (IExceptionSettings.SHOW_EXCEPTION_PAGE.equals((Object)unexpectedExceptionDisplay)) {
            Page currentPage = this.extractCurrentPage();
            return this.createPageRequestHandler(new PageProvider(new ExceptionErrorPage(e, currentPage)));
        }
        if (IExceptionSettings.SHOW_INTERNAL_ERROR_PAGE.equals((Object)unexpectedExceptionDisplay)) {
            return this.createPageRequestHandler(new PageProvider(application.getApplicationSettings().getInternalErrorPage()));
        }
        return new ErrorCodeRequestHandler(500);
    }

    private RenderPageRequestHandler createPageRequestHandler(PageProvider pageProvider) {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            throw new IllegalStateException("there is no current request cycle attached to this thread");
        }
        RenderPageRequestHandler.RedirectPolicy redirect = RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT;
        if (this.isProcessingAjaxRequest()) {
            redirect = RenderPageRequestHandler.RedirectPolicy.AUTO_REDIRECT;
        }
        return new RenderPageRequestHandler(pageProvider, redirect);
    }

    private boolean isProcessingAjaxRequest() {
        RequestCycle rc = RequestCycle.get();
        Request request = rc.getRequest();
        if (request instanceof WebRequest) {
            return ((WebRequest)request).isAjax();
        }
        return false;
    }

    private Page extractCurrentPage() {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestHandler handler = requestCycle.getActiveRequestHandler();
        if (handler == null) {
            handler = requestCycle.getRequestHandlerScheduledAfterCurrent();
        }
        if (handler instanceof IPageRequestHandler) {
            IPageRequestHandler pageRequestHandler = (IPageRequestHandler)handler;
            return (Page)pageRequestHandler.getPage();
        }
        return null;
    }
}

