/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.schema;

import com.evolveum.midpoint.util.DOMUtil;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SchemaProcessorUtil {
    public static boolean hasAnnotation(XSType xsType, QName annotationElementName) {
        if (xsType.getName() == null) {
            return false;
        }
        Element annotationElement = SchemaProcessorUtil.getAnnotationElement(xsType.getAnnotation(), annotationElementName);
        if (annotationElement != null) {
            return true;
        }
        if (xsType.getBaseType() != null && !xsType.getBaseType().equals(xsType)) {
            return SchemaProcessorUtil.hasAnnotation(xsType.getBaseType(), annotationElementName);
        }
        return false;
    }

    public static Element getAnnotationElement(XSAnnotation annotation, QName qname) {
        if (annotation == null) {
            return null;
        }
        List<Element> elements = SchemaProcessorUtil.getAnnotationElements(annotation, qname);
        if (elements.isEmpty()) {
            return null;
        }
        return elements.get(0);
    }

    public static List<Element> getAnnotationElements(XSAnnotation annotation, QName qname) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (annotation == null) {
            return elements;
        }
        Element xsdAnnotation = (Element)annotation.getAnnotation();
        NodeList list = xsdAnnotation.getElementsByTagNameNS(qname.getNamespaceURI(), qname.getLocalPart());
        if (list != null && list.getLength() > 0) {
            int i = 0;
            while (i < list.getLength()) {
                elements.add((Element)list.item(i));
                ++i;
            }
        }
        return elements;
    }

    public static QName getAnnotationQName(XSAnnotation annotation, QName qname) {
        Element element = SchemaProcessorUtil.getAnnotationElement(annotation, qname);
        if (element == null) {
            return null;
        }
        return DOMUtil.getQNameValue((Element)element);
    }
}

