/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.util;

import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import org.apache.commons.lang.Validate;

public final class Utils {
    private Utils() {
    }

    public static void resolveResource(ResourceObjectShadowType shadow, ProvisioningService provisioning, OperationResult result) throws CommunicationException, SchemaException, ObjectNotFoundException, ConfigurationException, SecurityViolationException {
        Validate.notNull((Object)shadow, (String)"Resource object shadow must not be null.");
        Validate.notNull((Object)provisioning, (String)"Provisioning service must not be null.");
        ResourceType resource = Utils.getResource(shadow, provisioning, result);
        shadow.setResourceRef(null);
        shadow.setResource(resource);
    }

    public static ResourceType getResource(ResourceObjectShadowType shadow, ProvisioningService provisioning, OperationResult result) throws CommunicationException, SchemaException, ObjectNotFoundException, ConfigurationException, SecurityViolationException {
        if (shadow.getResource() != null) {
            return shadow.getResource();
        }
        if (shadow.getResourceRef() == null) {
            throw new IllegalArgumentException("Couldn't resolve resource. Resource object shadow doesn't contain resource nor resource ref.");
        }
        ObjectReferenceType resourceRef = shadow.getResourceRef();
        return (ResourceType)provisioning.getObject(ResourceType.class, resourceRef.getOid(), result).asObjectable();
    }
}

