/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.synchronizer.AssignmentProcessor;
import com.evolveum.midpoint.model.synchronizer.ConsolidationProcessor;
import com.evolveum.midpoint.model.synchronizer.OutboundProcessor;
import com.evolveum.midpoint.model.synchronizer.ShadowConstraintsChecker;
import com.evolveum.midpoint.model.synchronizer.SynchronizerUtil;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.IterationSpecificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceAccountTypeDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AccountValuesProcessor {
    private static final Trace LOGGER = TraceManager.getTrace(AccountValuesProcessor.class);
    @Autowired(required=true)
    private OutboundProcessor outboundProcessor;
    @Autowired(required=true)
    private ConsolidationProcessor consolidationProcessor;
    @Autowired(required=true)
    private AssignmentProcessor assignmentProcessor;
    @Autowired(required=true)
    @Qualifier(value="cacheRepositoryService")
    RepositoryService repositoryService;
    @Autowired(required=true)
    private PrismContext prismContext;

    public void process(SyncContext context, OperationResult result) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException, ObjectAlreadyExistsException {
        block0: for (AccountSyncContext accountContext : context.getAccountContexts()) {
            PolicyDecision policyDecision = accountContext.getPolicyDecision();
            if (policyDecision != null && policyDecision == PolicyDecision.UNLINK) continue;
            int maxIterations = this.determineMaxIterations(accountContext);
            int iteration = 0;
            while (true) {
                accountContext.setIteration(iteration);
                String iterationToken = this.formatIterationToken(iteration);
                accountContext.setIterationToken(iterationToken);
                this.assignmentProcessor.processAssignmentsAccountValues(accountContext, result);
                context.recomputeNew();
                this.outboundProcessor.processOutbound(context, accountContext, result);
                context.recomputeNew();
                this.consolidationProcessor.consolidateValues(context, accountContext, result);
                context.recomputeNew();
                SynchronizerUtil.traceContext("values", context, true);
                ShadowConstraintsChecker checker = new ShadowConstraintsChecker(accountContext);
                checker.setPrismContext(this.prismContext);
                checker.setRepositoryService(this.repositoryService);
                checker.check(result);
                if (checker.isSatisfiesConstraints()) continue block0;
                if (++iteration > maxIterations) {
                    StringBuilder sb = new StringBuilder();
                    if (iteration == 1) {
                        sb.append("Error processing ");
                    } else {
                        sb.append("Too many iterations (" + iteration + ") for ");
                    }
                    sb.append(accountContext.getHumanReadableAccountName());
                    if (iteration == 1) {
                        sb.append(": constraint violation: ");
                    } else {
                        sb.append(": cannot determine valuest that satisfy constraints: ");
                    }
                    sb.append(checker.getMessages());
                    throw new ObjectAlreadyExistsException(sb.toString());
                }
                this.cleanupContext(accountContext);
            }
        }
    }

    private int determineMaxIterations(AccountSyncContext accountContext) {
        IterationSpecificationType iteration;
        ResourceAccountTypeDefinitionType accDef = accountContext.getResourceAccountTypeDefinitionType();
        if (accDef != null && (iteration = accDef.getIteration()) != null) {
            return iteration.getMaxIterations();
        }
        return 0;
    }

    private String formatIterationToken(int iteration) {
        if (iteration == 0) {
            return "";
        }
        return Integer.toString(iteration);
    }

    private boolean isInDelta(PrismProperty<?> attr, ObjectDelta<AccountShadowType> delta) {
        if (delta == null) {
            return false;
        }
        return delta.hasItemDelta(new PropertyPath(new QName[]{ResourceObjectShadowType.F_ATTRIBUTES, attr.getName()}));
    }

    private void cleanupContext(AccountSyncContext accountContext) throws SchemaException {
        accountContext.setAccountSecondaryDelta(null);
        accountContext.clearIntermediateResults();
        accountContext.recomputeAccountNew();
    }
}

