/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.util;

import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.mchange.v2.c3p0.AbstractConnectionCustomizer;
import java.sql.Connection;
import org.h2.jdbc.JdbcConnection;

public class MidPointConnectionCustomizer
extends AbstractConnectionCustomizer {
    private static final Trace LOGGER = TraceManager.getTrace(MidPointConnectionCustomizer.class);

    public void onAcquire(Connection connection, String parentDataSourceIdentityToken) throws Exception {
        if (!(connection instanceof JdbcConnection)) {
            this.updateTransactionIsolation(connection);
        }
    }

    public void onCheckOut(Connection connection, String parentDataSourceIdentityToken) throws Exception {
        if (connection instanceof JdbcConnection) {
            this.updateTransactionIsolation(connection);
        }
    }

    private void updateTransactionIsolation(Connection connection) throws Exception {
        LOGGER.trace("Setting connection transaction isolation to 8 (serializable).");
        connection.setTransactionIsolation(8);
    }
}

