/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;
import org.apache.ibatis.io.ExternalResources;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.commands.BaseCommand;

public class NewCommand
extends BaseCommand {
    private static final String MIGRATIONS_HOME = "MIGRATIONS_HOME";
    private static final String MIGRATIONS_HOME_PROPERTY = "migrationHome";
    private static final String CUSTOM_NEW_COMMAND_TEMPATE_PROPERTY = "new_command.template";
    private static final String MIGRATIONS_PROPERTIES = "migration.properties";

    public NewCommand(File repository, String environment, String template, boolean force) {
        super(repository, environment, template, force);
    }

    public void execute(String ... params) {
        if (this.paramsEmpty(params)) {
            throw new MigrationException("No description specified for new migration.");
        }
        String description = params[0];
        Properties variables = new Properties();
        variables.setProperty("description", description);
        this.existingEnvironmentFile();
        String filename = this.getNextIDAsString() + "_" + description.replace(' ', '_') + ".sql";
        String migrationsHome = "";
        migrationsHome = System.getenv(MIGRATIONS_HOME);
        if (migrationsHome == null) {
            migrationsHome = System.getProperty(MIGRATIONS_HOME_PROPERTY);
        }
        if (this.template != null) {
            this.copyExternalResourceTo(this.template, this.scriptFile(filename), variables);
        } else if (migrationsHome != null && !migrationsHome.equals("")) {
            try {
                String customConfiguredTemplate = ExternalResources.getConfiguredTemplate(migrationsHome + "/" + MIGRATIONS_PROPERTIES, CUSTOM_NEW_COMMAND_TEMPATE_PROPERTY);
                this.copyExternalResourceTo(migrationsHome + "/" + customConfiguredTemplate, this.scriptFile(filename), variables);
            }
            catch (FileNotFoundException e) {
                this.printStream.append("Your migrations configuration did not find your custom template.  Using the default template.");
                this.copyDefaultTemplate(variables, filename);
            }
        } else {
            this.copyDefaultTemplate(variables, filename);
        }
        this.printStream.println("Done!");
        this.printStream.println();
    }

    private void copyDefaultTemplate(Properties variables, String filename) {
        this.copyResourceTo("org/apache/ibatis/migration/template_migration.sql", this.scriptFile(filename), variables);
    }
}

