/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public final class TokenList
extends ElementList
implements Iterable<byte[]> {
    byte[][] list;

    public TokenList() {
        this(8);
    }

    public TokenList(int is) {
        this.list = new byte[is][];
    }

    public TokenList(double f) {
        this(8);
        this.factor = f;
    }

    public void add(byte[] e) {
        if (this.size == this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = e;
    }

    public void add(long e) {
        this.add(Token.token(e));
    }

    public void add(String e) {
        this.add(Token.token(e));
    }

    public byte[] get(int i) {
        return this.list[i];
    }

    public void set(int i, byte[] e) {
        if (i >= this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize(i + 1));
        }
        this.list[i] = e;
        this.size = Math.max(this.size, i + 1);
    }

    public byte[] pop() {
        return this.list[--this.size];
    }

    public void push(byte[] val) {
        this.add(val);
    }

    public byte[] peek() {
        return this.list[this.size - 1];
    }

    public boolean contains(byte[] e) {
        int i = 0;
        while (i < this.size) {
            if (Token.eq(this.list[i], e)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public byte[][] toArray() {
        return Array.copyOf(this.list, this.size);
    }

    public String[] toStringArray() {
        String[] items = new String[this.size];
        int i = 0;
        while (i < items.length) {
            items[i] = Token.string(this.list[i]);
            ++i;
        }
        return items;
    }

    public void sort(final boolean cs) {
        Arrays.sort(this.list, 0, this.size, new Comparator<byte[]>(){

            @Override
            public int compare(byte[] s1, byte[] s2) {
                return cs ? Token.diff(s1, s2) : Token.diff(Token.lc(s1), Token.lc(s2));
            }
        });
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            private int c = -1;

            @Override
            public boolean hasNext() {
                return ++this.c < TokenList.this.size;
            }

            @Override
            public byte[] next() {
                return TokenList.this.list[this.c];
            }

            @Override
            public void remove() {
                Util.notexpected(new Object[0]);
            }
        };
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder(String.valueOf(Util.name(this)) + '[');
        int i = 0;
        while (i < this.size) {
            if (i != 0) {
                tb.add(", ");
            }
            tb.add(this.list[i]);
            ++i;
        }
        return tb.add(93).toString();
    }
}

