/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import org.basex.build.DirParser;
import org.basex.build.MemBuilder;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.io.IO;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.up.primitives.InsertBase;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.ObjList;

public final class Add
extends InsertBase {
    private final ObjList<Item> docs;
    private final byte[] name;
    private final byte[] path;
    private final Context ctx;

    public Add(Data trg, InputInfo i, ObjList<Item> d, byte[] n, byte[] p, Context c) {
        super(PrimitiveType.INSERTAFTER, Add.lastDoc(trg), trg, i, null);
        this.docs = d;
        this.name = n == null || n.length == 0 ? null : n;
        this.path = p == null || p.length == 0 ? null : p;
        this.ctx = c;
    }

    @Override
    public boolean checkTextAdjacency(int c) {
        return false;
    }

    @Override
    public void merge(UpdatePrimitive p) {
        for (Item d : ((Add)p).docs) {
            this.docs.add(d);
        }
    }

    @Override
    public void apply() {
        super.apply();
        this.data.insert(this.pre + this.data.size(this.pre, this.data.kind(this.pre)), -1, this.md);
        if (this.ctx.data != null) {
            this.ctx.update();
        }
    }

    @Override
    public void prepare() throws QueryException {
        this.md = new MemData(this.data);
        for (Item d : this.docs) {
            MemData docData;
            if (d.node()) {
                ANode doc = (ANode)d;
                if (doc.ndType() != NodeType.DOC) {
                    Err.UPDOCTYPE.thrw(this.input, doc);
                }
                docData = new MemData(this.data);
                new DataBuilder(docData).build(doc);
            } else if (d.str()) {
                String docpath = Token.string(d.atom(this.input));
                String nm = this.ctx.mprop.random(this.data.meta.name);
                DirParser p = new DirParser(IO.get(docpath), this.ctx.prop);
                MemBuilder b = new MemBuilder(nm, p, this.ctx.prop);
                try {
                    docData = b.build();
                }
                catch (IOException e) {
                    throw Err.DOCERR.thrw(this.input, docpath);
                }
            } else {
                throw Err.STRNODTYPE.thrw(this.input, this, d.type);
            }
            this.md.insert(this.md.meta.size, -1, docData);
        }
        IntList pres = this.md.doc();
        if (pres.size() == 1 && this.name != null) {
            byte[] nm = this.path == null ? this.name : Token.concat(this.path, Token.SLASH, this.name);
            this.md.update(pres.get(0), 0, nm);
        } else if (this.path != null) {
            int i = 0;
            int is = pres.size();
            while (i < is) {
                int d = pres.get(i);
                byte[] old = this.md.text(d, true);
                int p = Token.lastIndexOf(old, 47);
                byte[] nm = p < 0 ? old : Token.subtoken(old, p + 1);
                this.md.update(d, 0, Token.concat(this.path, Token.SLASH, nm));
                ++i;
            }
        }
    }

    private static int lastDoc(Data data) {
        IntList docs = data.doc();
        return docs.size() == 0 ? 0 : docs.get(docs.size() - 1);
    }

    public String toString() {
        return String.valueOf(Util.name(this)) + "[" + this.targetNode() + "]";
    }
}

