/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import javax.xml.namespace.QName;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Item;
import org.basex.query.item.Uri;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public final class QNm
extends Item {
    private Uri uri;
    private byte[] val = Token.EMPTY;
    private int ns;

    public QNm() {
        super(AtomType.QNM);
    }

    public QNm(byte[] n) {
        this();
        this.name(n);
    }

    public QNm(byte[] n, QueryContext ctx, InputInfo ii) throws QueryException {
        this(n);
        if (!XMLToken.isQName(this.val)) {
            Err.value(ii, this.type, this.val);
        }
        if (this.ns()) {
            this.uri(ctx.ns.uri(this.pref(), false, ii));
        }
    }

    public QNm(byte[] n, Uri u) {
        this(n);
        this.uri(u);
    }

    public QNm(byte[] n, byte[] u) {
        this(n);
        this.uri(u);
    }

    public QNm(QName qn) {
        this(Token.token(QNm.qname(qn)), Token.token(qn.getNamespaceURI()));
    }

    public void uri(Uri u) {
        this.uri = u;
    }

    public void uri(byte[] u) {
        this.uri(Uri.uri(u));
    }

    public Uri uri() {
        return this.uri == null ? Uri.EMPTY : this.uri;
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    private static String qname(QName qn) {
        String name = qn.getLocalPart();
        String pre = qn.getPrefix();
        return !pre.isEmpty() ? String.valueOf(pre) + ":" + name : name;
    }

    public void name(byte[] nm) {
        this.val = nm;
        this.ns = Token.indexOf(this.val, 58);
    }

    @Override
    public byte[] atom(InputInfo ii) {
        return this.val;
    }

    public byte[] atom() {
        return this.val;
    }

    @Override
    public boolean bool(InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.thrw(ii, this.type, this);
    }

    @Override
    public boolean eq(InputInfo ii, Item it) {
        return this.eq((QNm)it);
    }

    public boolean eq(QNm n) {
        return n == this || Token.eq(this.ln(), n.ln()) && this.uri().eq(n.uri());
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        throw Err.diff(ii, it, this);
    }

    public boolean ns() {
        return this.ns != -1;
    }

    public byte[] pref() {
        return this.ns == -1 ? Token.EMPTY : Token.substring(this.val, 0, this.ns);
    }

    public byte[] ln() {
        return this.ns == -1 ? this.val : Token.substring(this.val, this.ns + 1);
    }

    @Override
    public QName toJava() {
        return new QName(Token.string(this.uri().atom()), Token.string(this.ln()), Token.string(this.pref()));
    }

    public byte[] full() {
        return new TokenBuilder().add(123).add(this.uri().atom()).add(125).add(this.ln()).finish();
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return Token.hash(this.ln());
    }

    @Override
    public String toString() {
        return "\"" + Token.string(this.val) + "\"";
    }
}

