/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.core.Prop;
import org.basex.query.QueryException;
import org.basex.query.ft.FTTokens;
import org.basex.query.ft.FTWords;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.ft.FTBitapSearch;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public final class FTTokenizer {
    private final FTBitapSearch.TokenComparator cmp;
    final TokenObjMap<FTTokens> cache = new TokenObjMap();
    final Levenshtein ls = new Levenshtein();
    final FTWords words;
    final FTOpt opt;
    final int lserr;

    public FTTokenizer(FTWords w, FTOpt o, Prop pr) {
        this.words = w;
        this.opt = o;
        this.lserr = pr.num(Prop.LSERROR);
        this.cmp = new FTBitapSearch.TokenComparator(){

            @Override
            public boolean equal(byte[] in, byte[] qu) throws QueryException {
                return FTTokenizer.this.opt.sw != null && FTTokenizer.this.opt.sw.id(qu) != 0 || !(FTTokenizer.this.opt.is(FTFlag.FZ) ? !FTTokenizer.this.ls.similar(in, qu, FTTokenizer.this.lserr) : (FTTokenizer.this.opt.is(FTFlag.WC) ? !FTTokenizer.wc(FTTokenizer.this.words.input, in, qu, 0, 0) : !Token.eq(in, qu)));
            }
        };
    }

    FTLexer copy(FTLexer lex) {
        FTOpt to = lex.ftOpt();
        to.set(FTFlag.ST, this.opt.is(FTFlag.ST));
        to.set(FTFlag.DC, this.opt.is(FTFlag.DC));
        to.set(FTFlag.CS, this.opt.is(FTFlag.CS));
        to.ln = this.opt.ln;
        to.th = this.opt.th;
        to.sd = this.opt.sd;
        return new FTLexer(to).init(lex.text());
    }

    FTTokens cache(byte[] query) throws QueryException {
        FTTokens tokens = this.cache.get(query);
        if (tokens == null) {
            tokens = new FTTokens();
            this.cache.add(query, tokens);
            FTLexer quLex = new FTLexer(this.opt).init(query);
            TokenList quList = new TokenList(1);
            while (quLex.hasNext()) {
                quList.add(((FTIterator)quLex).nextToken());
            }
            tokens.add(quList);
            if (this.opt.th != null) {
                byte[][] byArray = this.opt.th.find(this.words.input, query);
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte[] ext = byArray[n2];
                    TokenList tl = new TokenList(1);
                    ((FTIterator)quLex).init(ext);
                    while (quLex.hasNext()) {
                        tl.add(((FTIterator)quLex).nextToken());
                    }
                    tokens.add(tl);
                    ++n2;
                }
            }
        }
        return tokens;
    }

    int contains(FTTokens query, FTLexer input) throws QueryException {
        input.init();
        FTBitapSearch bs = new FTBitapSearch(input, query, this.cmp);
        int c = 0;
        while (bs.hasNext()) {
            int pos = bs.next();
            this.words.add(pos, pos + query.length() - 1);
            ++c;
        }
        ++this.words.matches.sTokenNum;
        this.words.first = false;
        return c;
    }

    static boolean wc(InputInfo ii, byte[] t, byte[] q, int tp, int qp) throws QueryException {
        int ql = qp;
        int tl = tp;
        while (ql < q.length) {
            if (q[ql] == 46) {
                byte c = ++ql < q.length ? q[ql] : (byte)0;
                int n = 0;
                int m = Integer.MAX_VALUE;
                if (c == 63) {
                    ++ql;
                    m = 1;
                } else if (c == 42) {
                    ++ql;
                } else if (c == 43) {
                    ++ql;
                    n = 1;
                } else if (c == 123) {
                    m = 0;
                    while (true) {
                        byte by = c = ++ql < q.length ? q[ql] : (byte)0;
                        if (c >= 48 && c <= 57) {
                            n = (n << 3) + (n << 1) + c - 48;
                            continue;
                        }
                        if (c == 44) break;
                        Err.FTREG.thrw(ii, new Object[]{q});
                    }
                    while (true) {
                        byte by = c = ++ql < q.length ? q[ql] : (byte)0;
                        if (c >= 48 && c <= 57) {
                            m = (m << 3) + (m << 1) + c - 48;
                            continue;
                        }
                        if (c == 125) break;
                        Err.FTREG.thrw(ii, new Object[]{q});
                    }
                    ++ql;
                } else {
                    m = 1;
                    n = 1;
                }
                while (!FTTokenizer.wc(ii, t, q, tl + n, ql)) {
                    if (tl + ++n <= t.length) continue;
                    return false;
                }
                if (n > m) {
                    return false;
                }
                tl += n;
                continue;
            }
            if (q[ql] == 92 && ++ql == q.length) {
                Err.FTREG.thrw(ii, new Object[]{q});
            }
            if (tl < t.length && t[tl++] == q[ql++]) continue;
            return false;
        }
        return tl == t.length;
    }
}

