/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class TypeCase
extends Single {
    final Var var;

    public TypeCase(InputInfo ii, Var v, Expr r) {
        super(ii, r);
        this.var = v;
    }

    @Override
    public TypeCase comp(QueryContext ctx) throws QueryException {
        return this.comp(ctx, null);
    }

    TypeCase comp(QueryContext ctx, Value v) throws QueryException {
        if (this.var.name == null) {
            super.comp(ctx);
        } else {
            int s = ctx.vars.size();
            ctx.vars.add(v == null ? this.var : this.var.bind(v, ctx).copy());
            super.comp(ctx);
            ctx.vars.reset(s);
        }
        this.type = this.expr.type();
        return this;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR || super.uses(u);
    }

    Iter iter(QueryContext ctx, Value seq) throws QueryException {
        if (this.var.type != null && !this.var.type.instance(seq)) {
            return null;
        }
        if (this.var.name == null) {
            return ctx.iter(this.expr);
        }
        int s = ctx.vars.size();
        ctx.vars.add(this.var.bind(seq, ctx).copy());
        ValueIter ic = ctx.value(this.expr).iter();
        ctx.vars.reset(s);
        return ic;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.VAR, this.var.name != null ? this.var.name.atom() : Token.EMPTY});
        this.expr.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.var.type == null ? "default" : "case");
        if (this.var.name != null) {
            tb.add(32);
        }
        return tb.add(this.var + " " + "return" + ' ' + this.expr).toString();
    }

    @Override
    TypeCase markTailCalls() {
        this.expr = this.expr.markTailCalls();
        return this;
    }
}

