/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.basex.core.Text;
import org.basex.data.Nodes;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenu;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.editor.EditorArea;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.BoolList;
import org.basex.util.list.ObjList;

public final class EditorView
extends View {
    private static final String ERRSTRING = String.valueOf(Text.STOPPED) + ' ' + (String.valueOf(Text.LINEINFO) + ", " + Text.COLINFO).replaceAll("%", "([0-9]+)");
    private static final Pattern FILEPATTERN = Pattern.compile(String.valueOf(ERRSTRING) + ' ' + Text.FILEINFO.replaceAll("%", "(.*)") + ":");
    final BaseXButton stop;
    final BaseXLabel info;
    final BaseXLabel pos;
    final BaseXTabs tabs;
    final BaseXTextField find;
    int threadID;
    String errFile;
    int errPos;
    private final BaseXLabel header;
    private final BaseXBack south;
    final BaseXButton go;
    private final BaseXButton filter;

    public EditorView(ViewNotifier man) {
        super("editor", Text.HELPXQUERYY, man);
        this.border(6, 6, 6, 6).layout(new BorderLayout()).setFocusable(false);
        this.header = new BaseXLabel(Text.EDITORTIT, true, false);
        BaseXButton openB = BaseXButton.command(GUICommands.EDITOPEN, this.gui);
        final BaseXButton saveB = new BaseXButton(this.gui, "editsave", Token.token(Text.GUISAVETT));
        final BaseXButton hist = new BaseXButton(this.gui, "hist", Text.HELPRECENT);
        this.find = new BaseXTextField(this.gui);
        this.find.setSearch(null);
        BaseXLayout.setHeight(this.find, (int)openB.getPreferredSize().getHeight());
        BaseXBack sp = new BaseXBack(GUIConstants.Fill.NONE).layout(new TableLayout(1, 7));
        sp.add(this.find);
        sp.add(Box.createHorizontalStrut(5));
        sp.add(openB);
        sp.add(Box.createHorizontalStrut(1));
        sp.add(saveB);
        sp.add(Box.createHorizontalStrut(1));
        sp.add(hist);
        BaseXBack b = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        b.add((Component)this.header, "Center");
        b.add((Component)sp, "East");
        this.add((Component)b, "North");
        this.tabs = new BaseXTabs(this.gui);
        this.tabs.setFocusable(false);
        this.addCreateTab();
        this.addTab();
        this.add((Component)this.tabs, "Center");
        this.south = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout(8, 0));
        this.info = new BaseXLabel(" ");
        this.info.setText("OK", GUIConstants.Msg.SUCCESS);
        this.pos = new BaseXLabel(" ");
        sp = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout(8, 0));
        sp.add((Component)this.info, "Center");
        sp.add((Component)this.pos, "East");
        this.south.add((Component)sp, "Center");
        this.stop = new BaseXButton(this.gui, "stop", Text.HELPSTOP);
        this.stop.addKeyListener(this);
        this.stop.setEnabled(false);
        this.go = new BaseXButton(this.gui, "go", Text.HELPGO);
        this.go.addKeyListener(this);
        this.filter = BaseXButton.command(GUICommands.FILTER, this.gui);
        this.filter.addKeyListener(this);
        sp = new BaseXBack(GUIConstants.Fill.NONE).border(4, 0, 0, 0).layout(new TableLayout(1, 5));
        sp.add(this.stop);
        sp.add(Box.createHorizontalStrut(1));
        sp.add(this.go);
        sp.add(Box.createHorizontalStrut(1));
        sp.add(this.filter);
        this.south.add((Component)sp, "East");
        this.add((Component)this.south, "South");
        this.refreshLayout();
        saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu pop = new JPopupMenu();
                StringBuilder mnem = new StringBuilder();
                JMenuItem sa = GUIMenu.newItem(GUICommands.EDITSAVE, EditorView.this.gui, mnem);
                JMenuItem sas = GUIMenu.newItem(GUICommands.EDITSAVEAS, EditorView.this.gui, mnem);
                GUICommands.EDITSAVE.refresh(EditorView.this.gui, sa);
                GUICommands.EDITSAVEAS.refresh(EditorView.this.gui, sas);
                pop.add(sa);
                pop.add(sas);
                pop.show(saveB, 0, saveB.getHeight());
            }
        });
        hist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = new JPopupMenu();
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ac) {
                        EditorView.this.open(new IOFile(ac.getActionCommand()));
                    }
                };
                if (EditorView.this.gui.gprop.strings(GUIProp.QUERIES).length == 0) {
                    popup.add(new JMenuItem("- No recently opened files -"));
                }
                String[] stringArray = EditorView.this.gui.gprop.strings(GUIProp.QUERIES);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String en = stringArray[n2];
                    JMenuItem jmi = new JMenuItem(en);
                    jmi.addActionListener(al);
                    popup.add(jmi);
                    ++n2;
                }
                popup.show(hist, 0, hist.getHeight());
            }
        });
        this.info.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EditorArea edit = EditorView.this.getEditor();
                if (EditorView.this.errFile != null) {
                    edit = EditorView.this.find(IO.get(EditorView.this.errFile), false);
                    if (edit == null) {
                        edit = EditorView.this.open(new IOFile(EditorView.this.errFile));
                    }
                    EditorView.this.tabs.setSelectedComponent(edit);
                    edit.error = EditorView.this.errPos;
                }
                if (edit.error == -1) {
                    return;
                }
                edit.setCaret(edit.error);
                edit.requestFocusInWindow();
                edit.markError();
                EditorView.this.pos.setText(edit.pos());
            }
        });
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.stop.setEnabled(false);
                EditorView.this.go.setEnabled(false);
                EditorView.this.info.setText("OK", GUIConstants.Msg.SUCCESS);
                EditorView.this.gui.stop();
            }
        });
        this.go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.getEditor().query();
            }
        });
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EditorArea edit = EditorView.this.getEditor();
                if (edit == null) {
                    return;
                }
                edit.setSearch(EditorView.this.find);
                EditorView.this.gui.refreshControls();
                EditorView.this.refreshMark();
                if (EditorView.this.gui.gprop.is(GUIProp.EXECRT)) {
                    edit.query();
                }
            }
        });
        BaseXLayout.addDrop(this, new BaseXLayout.DropHandler(){

            @Override
            public void drop(Object file) {
                if (file instanceof File) {
                    EditorView.this.open(new IOFile((File)file));
                }
            }
        });
    }

    @Override
    public void refreshInit() {
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        this.go.setEnabled(this.getEditor().exec && !this.gui.gprop.is(GUIProp.EXECRT));
        Nodes marked = this.gui.context.marked;
        this.filter.setEnabled(!this.gui.gprop.is(GUIProp.FILTERRT) && marked != null && marked.size() != 0L);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
    }

    @Override
    public void refreshLayout() {
        this.header.setFont(GUIConstants.lfont);
        EditorArea[] editorAreaArray = this.editors();
        int n = editorAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorArea edit = editorAreaArray[n2];
            edit.setFont(GUIConstants.mfont);
            ++n2;
        }
        this.refreshMark();
    }

    @Override
    public void refreshUpdate() {
    }

    @Override
    public boolean visible() {
        return this.gui.gprop.is(GUIProp.SHOWEDITOR);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gprop.set(GUIProp.SHOWEDITOR, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    public void open() {
        BaseXFileChooser fc = new BaseXFileChooser(Text.GUIOPEN, this.gui.gprop.get(GUIProp.XQPATH), this.gui);
        fc.addFilter("XQuery Files", IO.XQSUFFIXES);
        IOFile file = fc.select(BaseXFileChooser.Mode.FOPEN);
        if (file != null) {
            this.open(file);
            this.getEditor().opened = true;
        }
    }

    public boolean save() {
        EditorArea edit = this.getEditor();
        if (!edit.opened) {
            return this.saveAs();
        }
        this.save(edit);
        return true;
    }

    public boolean saveAs() {
        EditorArea edit = this.getEditor();
        BaseXFileChooser fc = new BaseXFileChooser(Text.GUISAVEAS, edit.file().path(), this.gui);
        fc.addFilter("XQuery Files", IO.XQSUFFIXES);
        IOFile file = fc.select(BaseXFileChooser.Mode.FSAVE);
        if (file == null) {
            return false;
        }
        edit.file(file);
        this.save(edit);
        return true;
    }

    public void newFile() {
        this.addTab();
        this.refresh(false, true);
    }

    public EditorArea open(IOFile file) {
        EditorArea edit;
        if (!this.visible()) {
            GUICommands.SHOWXQUERY.execute(this.gui);
        }
        if ((edit = this.find(file, true)) != null) {
            this.tabs.setSelectedComponent(edit);
            return edit;
        }
        edit = this.getEditor();
        if (edit.opened || edit.mod) {
            edit = this.addTab();
        }
        try {
            edit.setText(file.content());
            edit.opened = true;
            edit.file(file);
            this.gui.gprop.recent(file);
            this.refresh(false, true);
            if (this.gui.gprop.is(GUIProp.EXECRT)) {
                edit.query();
            }
            return edit;
        }
        catch (IOException ex) {
            Dialog.error(this.gui, Text.NOTOPENED);
            return edit;
        }
    }

    public void close(EditorArea edit) {
        EditorArea ea;
        EditorArea editorArea = ea = edit != null ? edit : this.getEditor();
        if (!this.confirm(ea)) {
            return;
        }
        this.tabs.remove(ea);
        int t = this.tabs.getTabCount();
        int i = this.tabs.getSelectedIndex();
        if (t == 1) {
            this.addTab();
        } else if (i + 1 == t) {
            this.tabs.setSelectedIndex(i - 1);
        }
    }

    public void reset() {
        ++this.threadID;
        this.errFile = null;
        this.info.setToolTipText(null);
        this.info.setText("OK", GUIConstants.Msg.SUCCESS);
        this.stop.setEnabled(false);
    }

    public void start() {
        final int thread = ++this.threadID;
        new Thread(){

            @Override
            public void run() {
                if (EditorView.this.gui.updating) {
                    EditorView.this.go.setEnabled(false);
                }
                Performance.sleep(200L);
                if (thread == EditorView.this.threadID) {
                    EditorView.this.info.setToolTipText(null);
                    EditorView.this.info.setText(Text.INFOWAIT, GUIConstants.Msg.SUCCESS);
                    if (!EditorView.this.gui.updating) {
                        EditorView.this.stop.setEnabled(true);
                    }
                }
            }
        }.start();
    }

    public void info(String inf, boolean ok) {
        ++this.threadID;
        this.info.setCursor(this.error(inf, ok) ? GUIConstants.CURSORHAND : GUIConstants.CURSORARROW);
        this.info.setText(ok ? "OK" : inf.replaceAll(String.valueOf(Text.STOPPED) + ".*\\r?\\n\\[.*?\\] ", ""), ok ? GUIConstants.Msg.SUCCESS : GUIConstants.Msg.ERROR);
        this.info.setToolTipText(ok ? null : inf);
        this.stop.setEnabled(false);
        this.go.setEnabled(true);
    }

    public boolean confirm() {
        EditorArea[] editorAreaArray = this.editors();
        int n = editorAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorArea edit = editorAreaArray[n2];
            if (!this.confirm(edit)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean saveable() {
        EditorArea area = this.getEditor();
        return !area.opened || area.mod;
    }

    EditorArea getEditor() {
        Component c = this.tabs.getSelectedComponent();
        return c instanceof EditorArea ? (EditorArea)c : null;
    }

    void refresh(boolean mod, boolean force) {
        EditorArea edit = this.getEditor();
        this.refreshMark();
        if (edit.mod == mod && !force) {
            return;
        }
        String title = edit.file().name();
        if (mod) {
            title = String.valueOf(title) + "*";
        }
        edit.label.setText(title);
        edit.mod = mod;
        this.gui.refreshControls();
    }

    EditorArea find(IO file, boolean opened) {
        EditorArea[] editorAreaArray = this.editors();
        int n = editorAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorArea edit = editorAreaArray[n2];
            if (edit.file().eq(file) && (!opened || edit.opened)) {
                return edit;
            }
            ++n2;
        }
        return null;
    }

    private void save(EditorArea edit) {
        try {
            edit.file().write(this.getEditor().getText());
            edit.opened = true;
            this.gui.gprop.recent(edit.file());
            this.refresh(false, true);
        }
        catch (IOException ex) {
            Dialog.error(this.gui, Text.NOTSAVED);
        }
    }

    private IOFile newTabFile() {
        BoolList bl = new BoolList();
        EditorArea[] editorAreaArray = this.editors();
        int n = editorAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorArea edit = editorAreaArray[n2];
            if (!edit.opened) {
                String n3 = edit.file().name().substring(Text.EDITORFILE.length());
                bl.set(n3.isEmpty() ? 1 : Integer.parseInt(n3), true);
            }
            ++n2;
        }
        int c = 0;
        while (++c < bl.size() && bl.get(c)) {
        }
        String dir = this.gui.gprop.get(GUIProp.XQPATH);
        return new IOFile(dir, String.valueOf(Text.EDITORFILE) + (c == 1 ? "" : Integer.valueOf(c)));
    }

    EditorArea addTab() {
        final EditorArea edit = new EditorArea(this, this.newTabFile());
        edit.setFont(GUIConstants.mfont);
        BaseXBack tab = new BaseXBack(new BorderLayout(10, 0)).mode(GUIConstants.Fill.NONE);
        tab.add((Component)edit.label, "Center");
        BaseXButton close = this.tabButton("editclose");
        close.setRolloverIcon(BaseXLayout.icon("cmd-editclose2"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.close(edit);
            }
        });
        tab.add((Component)close, "East");
        this.tabs.add((Component)edit, tab, this.tabs.getComponentCount() - 2);
        return edit;
    }

    private void addCreateTab() {
        BaseXButton add = this.tabButton("editnew");
        add.setRolloverIcon(BaseXLayout.icon("cmd-editnew2"));
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.addTab();
                EditorView.this.refresh(false, true);
            }
        });
        this.tabs.add((Component)new BaseXBack(), add, 0);
        this.tabs.setEnabledAt(0, false);
    }

    private BaseXButton tabButton(String icon) {
        BaseXButton b = new BaseXButton(this.gui, icon, null);
        b.border(2, 2, 2, 2).setContentAreaFilled(false);
        b.setFocusable(false);
        return b;
    }

    private boolean confirm(EditorArea edit) {
        Boolean ok;
        return !edit.mod || (ok = Dialog.yesNoCancel(this.gui, Util.info(Text.XQUERYCONF, edit.file().name()))) != null && (ok == false || this.save());
    }

    public EditorArea[] editors() {
        ObjList<EditorArea> edits = new ObjList<EditorArea>();
        Component[] componentArray = this.tabs.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof EditorArea) {
                edits.add((EditorArea)c);
            }
            ++n2;
        }
        return edits.toArray(new EditorArea[edits.size()]);
    }

    boolean error(String message, boolean ok) {
        this.errPos = -1;
        EditorArea edit = this.getEditor();
        String msg = message.replaceAll("[\\r\\n].*", "");
        if (!ok) {
            Matcher m = FILEPATTERN.matcher(msg);
            if (!m.matches()) {
                return true;
            }
            this.errFile = m.group(3);
            edit = this.find(IO.get(this.errFile), false);
            if (edit == null) {
                return true;
            }
            int el = Integer.parseInt(m.group(1));
            int ec = Integer.parseInt(m.group(2));
            int ll = this.errPos = edit.last.length;
            int e = 0;
            int l = 1;
            int c = 1;
            while (e < ll) {
                if (l > el || l == el && c == ec) {
                    this.errPos = e;
                    break;
                }
                if (edit.last[e] == 10) {
                    ++l;
                    c = 0;
                }
                ++c;
                e += Token.cl(edit.last, e);
            }
        }
        edit.error = this.errPos;
        edit.markError();
        return this.errPos != -1;
    }
}

