/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xqj;

import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import javax.xml.xquery.XQDataSource;
import javax.xml.xquery.XQException;
import org.basex.api.xqj.BXQConnection;
import org.basex.api.xqj.BXQException;
import org.basex.core.MainProp;
import org.basex.util.Util;

public final class BXQDataSource
implements XQDataSource {
    private PrintWriter log;
    private final Properties props = new Properties();
    private int timeout;

    public BXQDataSource() {
        this.props.setProperty("user", "admin");
        this.props.setProperty("password", "admin");
        this.props.setProperty("serverName", MainProp.HOST[1].toString());
        this.props.setProperty("port", MainProp.PORT[1].toString());
    }

    public BXQConnection getConnection() throws XQException {
        return this.getConnection(this.props.getProperty("user"), this.props.getProperty("password"));
    }

    public BXQConnection getConnection(Connection c) throws XQException {
        throw new BXQException("SQL sources not supported.", new Object[0]);
    }

    public BXQConnection getConnection(String name, String pw) throws XQException {
        return new BXQConnection(name, pw);
    }

    public int getLoginTimeout() {
        return this.timeout;
    }

    public PrintWriter getLogWriter() {
        return this.log;
    }

    public String getProperty(String key) throws XQException {
        String val;
        String string = val = key != null ? this.props.getProperty(key) : null;
        if (val == null) {
            throw new BXQException("Unknown property '%'.", new Object[0]);
        }
        return val;
    }

    public String[] getSupportedPropertyNames() {
        return new String[]{"user", "password"};
    }

    public void setLoginTimeout(int to) {
        this.timeout = to;
    }

    public void setLogWriter(PrintWriter out) {
        this.log = out;
    }

    public void setProperties(Properties prop) throws XQException {
        if (prop == null) {
            throw new BXQException("% argument must not be null.", Util.name(Properties.class));
        }
        for (Map.Entry<Object, Object> o : prop.entrySet()) {
            this.setProperty(o.getKey().toString(), o.getValue().toString());
        }
    }

    public void setProperty(String key, String val) throws XQException {
        this.getProperty(key);
        this.props.setProperty(key, val);
    }
}

