/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import org.basex.api.xmldb.BXCollection;
import org.basex.api.xmldb.BXXMLDBText;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Set;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public final class BXDatabase
implements Database,
BXXMLDBText {
    private final Context ctx = new Context();

    public boolean acceptsURI(String uri) throws XMLDBException {
        this.getCollectionName(uri);
        return true;
    }

    public Collection getCollection(String uri, String user, String password) throws XMLDBException {
        String name = this.getCollectionName(uri);
        boolean exists = this.ctx.mprop.dbexists(name);
        return exists ? new BXCollection(name, exists, this.ctx) : null;
    }

    public String getConformanceLevel() {
        return "0";
    }

    public String getName() {
        return Text.NAMELC;
    }

    public String getProperty(String key) {
        try {
            String prop = key.toUpperCase();
            return ((Object[])Prop.class.getField(prop).get(null))[1].toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setProperty(String key, String value) throws XMLDBException {
        try {
            new Set((Object)key, (Object)value).execute(this.ctx);
        }
        catch (BaseXException ex) {
            throw new XMLDBException(1, "Property could not be set: " + key);
        }
    }

    private String getCollectionName(String uri) throws XMLDBException {
        if (uri != null) {
            String lh;
            String host;
            String main;
            String string = main = uri.startsWith("xmldb:") ? uri : "xmldb:" + uri;
            if (main.startsWith(XMLDBURI) && (host = main.substring(XMLDBURI.length())).startsWith(lh = "localhost:" + this.ctx.mprop.num(MainProp.SERVERPORT) + "/")) {
                return host.substring(lh.length());
            }
        }
        throw new XMLDBException(5, "Invalid URI: " + uri);
    }
}

