/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.validator;

import com.evolveum.midpoint.common.validator.EventHandler;
import com.evolveum.midpoint.common.validator.EventResult;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.dom.DOMConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class Validator {
    private static final Trace LOGGER = TraceManager.getTrace(Validator.class);
    private static final String INPUT_STREAM_CHARSET = "utf-8";
    private static final String OPERATION_PREFIX = String.valueOf(Validator.class.getName()) + ".";
    private static final String OPERATION_RESOURCE_NAMESPACE_CHECK = String.valueOf(OPERATION_PREFIX) + "resourceNamespaceCheck";
    private static final String OPERATION_RESOURCE_BASICS_CHECK = String.valueOf(OPERATION_PREFIX) + "objectBasicsCheck";
    private static final String START_LINE_NUMBER = "startLineNumber";
    private static final String END_LINE_NUMBER = "endLineNumber";
    private boolean verbose = false;
    private boolean validateSchemas = true;
    private boolean allowAnyType = false;
    private EventHandler handler;
    private DOMConverter domConverter = new DOMConverter();
    private Unmarshaller unmarshaller = null;
    private PrismContext prismContext;
    private Schema midPointJavaxSchema;
    private javax.xml.validation.Validator xsdValidator;
    long progress = 0L;
    long errors = 0L;
    long stopAfterErrors = 0L;

    public Validator(PrismContext prismContext) {
        this.prismContext = prismContext;
        this.handler = null;
        this.initialize();
    }

    public Validator(PrismContext prismContext, EventHandler handler) {
        this.prismContext = prismContext;
        this.handler = handler;
        this.initialize();
    }

    private void initialize() {
        if (this.prismContext == null) {
            throw new IllegalStateException("No prism context set during validator initialization");
        }
        SchemaRegistry schemaRegistry = this.prismContext.getSchemaRegistry();
        this.midPointJavaxSchema = schemaRegistry.getJavaxSchema();
        this.xsdValidator = this.midPointJavaxSchema.newValidator();
        this.xsdValidator.setResourceResolver((LSResourceResolver)schemaRegistry);
    }

    public EventHandler getHandler() {
        return this.handler;
    }

    public void setHandler(EventHandler handler) {
        this.handler = handler;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setValidateSchema(boolean validateSchemas) {
        this.validateSchemas = validateSchemas;
    }

    public boolean getValidateSchema() {
        return this.validateSchemas;
    }

    public void setAllowAnyType(boolean allowAnyType) {
        this.allowAnyType = allowAnyType;
    }

    public boolean getAllowAnyType() {
        return this.allowAnyType;
    }

    public long getStopAfterErrors() {
        return this.stopAfterErrors;
    }

    public void setStopAfterErrors(long stopAfterErrors) {
        this.stopAfterErrors = stopAfterErrors;
    }

    public long getProgress() {
        return this.progress;
    }

    public long getErrors() {
        return this.errors;
    }

    private Unmarshaller createUnmarshaller(OperationResult validatorResult) {
        if (this.unmarshaller != null) {
            return this.unmarshaller;
        }
        try {
            JAXBContext jc = this.prismContext.getPrismJaxbProcessor().getContext();
            this.unmarshaller = jc.createUnmarshaller();
        }
        catch (JAXBException ex) {
            validatorResult.recordFatalError("Error initializing JAXB: " + ex.getMessage(), (Throwable)ex);
            if (this.handler != null) {
                this.handler.handleGlobalError(validatorResult);
            }
            throw new SystemException("Error initializing JAXB: " + ex.getMessage(), (Throwable)ex);
        }
        return this.unmarshaller;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(InputStream inputStream, OperationResult validatorResult, String objectResultOperationName) {
        XMLStreamReader stream = null;
        try {
            HashMap<String, String> rootNamespaceDeclarations = new HashMap<String, String>();
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            stream = xmlInputFactory.createXMLStreamReader(inputStream);
            int eventType = stream.nextTag();
            if (eventType != 1) throw new SystemException("StAX Malfunction?");
            if (!stream.getName().equals(SchemaConstants.C_OBJECTS)) {
                OperationResult objectResult = validatorResult.createSubresult(objectResultOperationName);
                ++this.progress;
                objectResult.addContext("progress", (Object)this.progress);
                EventResult cont = null;
                try {
                    cont = this.readFromStreamAndValidate(stream, objectResult, rootNamespaceDeclarations, validatorResult);
                }
                catch (RuntimeException e) {
                    objectResult.recordFatalError((Throwable)e);
                    throw e;
                }
                if (cont.isCont()) {
                    validatorResult.computeStatus("Validation failed", "Validation warnings");
                    return;
                }
                String message = null;
                message = cont.getReason() != null ? cont.getReason() : "Object validation failed (no reason given)";
                if (objectResult.isUnknown()) {
                    objectResult.recordFatalError(message);
                }
                validatorResult.recordFatalError(message);
                return;
            }
            int i = 0;
            while (i < stream.getNamespaceCount()) {
                rootNamespaceDeclarations.put(stream.getNamespacePrefix(i), stream.getNamespaceURI(i));
                ++i;
            }
            while (stream.hasNext()) {
                eventType = stream.next();
                if (eventType != 1) continue;
                OperationResult objectResult = validatorResult.createSubresult(objectResultOperationName);
                ++this.progress;
                objectResult.addContext("progress", (Object)this.progress);
                EventResult cont = null;
                try {
                    cont = this.readFromStreamAndValidate(stream, objectResult, rootNamespaceDeclarations, validatorResult);
                }
                catch (RuntimeException e) {
                    if (!objectResult.isUnknown()) throw e;
                    objectResult.recordFatalError((Throwable)e);
                    throw e;
                }
                if (objectResult.isError()) {
                    ++this.errors;
                }
                validatorResult.summarize();
                if (cont.isStop()) {
                    if (cont.getReason() != null) {
                        validatorResult.recordFatalError("Processing has been stopped: " + cont.getReason());
                        return;
                    }
                    validatorResult.recordFatalError("Processing has been stopped");
                    return;
                }
                if (cont.isCont() || this.stopAfterErrors <= 0L || this.errors < this.stopAfterErrors) continue;
                validatorResult.recordFatalError("Too many errors (" + this.errors + ")");
                return;
            }
        }
        catch (XMLStreamException ex) {
            validatorResult.recordFatalError("XML parsing error: " + ex.getMessage(), (Throwable)ex);
            if (this.handler == null) return;
            this.handler.handleGlobalError(validatorResult);
            return;
        }
        validatorResult.computeStatus(String.valueOf(this.errors) + " errors, " + (this.progress - this.errors) + " passed");
    }

    private EventResult readFromStreamAndValidate(XMLStreamReader stream, OperationResult objectResult, Map<String, String> rootNamespaceDeclarations, OperationResult validatorResult) {
        try {
            objectResult.addContext(START_LINE_NUMBER, (Object)stream.getLocation().getLineNumber());
            Document objectDoc = this.domConverter.buildDocument(stream);
            objectResult.addContext(END_LINE_NUMBER, (Object)stream.getLocation().getLineNumber());
            Element objectElement = DOMUtil.getFirstChildElement((Node)objectDoc);
            DOMUtil.setNamespaceDeclarations((Element)objectElement, rootNamespaceDeclarations);
            Node postValidationTree = null;
            if (this.validateSchemas) {
                postValidationTree = this.validateSchema(objectDoc, objectResult);
            }
            if (this.handler != null) {
                EventResult cont;
                try {
                    cont = this.handler.preMarshall(objectElement, postValidationTree, objectResult);
                }
                catch (RuntimeException e) {
                    objectResult.recordFatalError("Internal error: preMarshall call failed: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
                if (!cont.isCont()) {
                    if (objectResult.isUnknown()) {
                        objectResult.recordFatalError("Stopped after preMarshall, no reason given");
                    }
                    return cont;
                }
            }
            if (!objectResult.isAcceptable()) {
                if (objectResult.isUnknown()) {
                    objectResult.recordFatalError("Result not acceptable after preMarshall, no reason given");
                }
                return EventResult.skipObject();
            }
            PrismObject object = this.prismContext.parseObject(objectElement);
            try {
                object.checkConsistence();
            }
            catch (RuntimeException e) {
                objectResult.recordFatalError("Internal object inconsistence, probably a parser bug: " + e.getMessage(), (Throwable)e);
                return EventResult.skipObject();
            }
            Objectable objectType = null;
            if (object != null) {
                objectType = object.asObjectable();
            }
            if (this.verbose) {
                LOGGER.debug("Processing OID " + objectType.getOid());
            }
            objectResult.addContext("object", (Object)objectType);
            this.validateObject(objectType, objectResult);
            if (this.handler != null) {
                EventResult cont;
                try {
                    cont = this.handler.postMarshall(object, objectElement, objectResult);
                }
                catch (RuntimeException e) {
                    objectResult.recordFatalError("Internal error: postMarshall call failed: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
                if (!cont.isCont()) {
                    if (objectResult.isUnknown()) {
                        objectResult.recordFatalError("Stopped after postMarshall, no reason given");
                    }
                    return cont;
                }
            }
            objectResult.recomputeStatus();
            return EventResult.cont();
        }
        catch (SchemaException ex) {
            if (this.verbose) {
                ex.printStackTrace();
            }
            if (this.handler != null) {
                try {
                    this.handler.handleGlobalError(validatorResult);
                }
                catch (RuntimeException e) {
                    objectResult.recordFatalError("Internal error: handleGlobalError call failed: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            objectResult.recordFatalError((Throwable)ex);
            return EventResult.skipObject();
        }
        catch (XMLStreamException ex) {
            validatorResult.recordFatalError("XML parsing error: " + ex.getMessage(), (Throwable)ex);
            if (this.handler != null) {
                this.handler.handleGlobalError(validatorResult);
            }
            objectResult.recordFatalError((Throwable)ex);
            return EventResult.skipObject();
        }
    }

    private Node validateSchema(Document objectDoc, OperationResult objectResult) {
        OperationResult result = objectResult.createSubresult(String.valueOf(Validator.class.getName()) + ".validateSchema");
        DOMResult validationResult = new DOMResult();
        try {
            this.xsdValidator.validate(new DOMSource(objectDoc), validationResult);
        }
        catch (SAXException e) {
            result.recordFatalError("Validation error: " + e.getMessage(), (Throwable)e);
            objectResult.computeStatus("Validation error: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            result.recordFatalError("OI error during validation: " + e.getMessage(), (Throwable)e);
            objectResult.computeStatus("OI error during validation: " + e.getMessage());
            return null;
        }
        result.recordSuccess();
        return validationResult.getNode();
    }

    public void validateObject(Objectable object, OperationResult objectResult) {
        this.checkBasics(object, objectResult);
        if (object instanceof ResourceType) {
            ResourceType resource = (ResourceType)object;
            this.checkResource(resource, objectResult);
        }
        objectResult.recomputeStatus("Object validation has failed", "Validation warning");
        objectResult.recordSuccessIfUnknown();
    }

    void checkBasics(Objectable object, OperationResult objectResult) {
        OperationResult subresult = objectResult.createSubresult(OPERATION_RESOURCE_BASICS_CHECK);
        this.checkName(object, object.getName(), "name", subresult);
        subresult.recordSuccessIfUnknown();
    }

    void checkResource(ResourceType resource, OperationResult objectResult) {
        OperationResult subresult = objectResult.createSubresult(OPERATION_RESOURCE_NAMESPACE_CHECK);
        this.checkUri((Objectable)resource, ResourceTypeUtil.getResourceNamespace((ResourceType)resource), "namespace", subresult);
        subresult.recordSuccessIfUnknown();
    }

    void checkName(Objectable object, String value, String propertyName, OperationResult subResult) {
        if (value == null || value.isEmpty()) {
            this.error("Empty property", object, propertyName, subResult);
        }
    }

    void checkUri(Objectable object, String value, String propertyName, OperationResult subResult) {
        if (StringUtils.isEmpty((String)value)) {
            this.error("Empty property", object, propertyName, subResult);
            return;
        }
        try {
            URI uri = new URI(value);
            if (uri.getScheme() == null) {
                this.error("URI is supposed to be absolute", object, propertyName, subResult);
            }
        }
        catch (URISyntaxException ex) {
            this.error("Wrong URI syntax: " + ex, object, propertyName, subResult);
        }
    }

    void error(String message, Objectable object, OperationResult subResult) {
        subResult.addContext("object", (Object)object);
        subResult.recordFatalError(message);
    }

    void error(String message, Objectable object, String propertyName, OperationResult subResult) {
        subResult.addContext("object", (Object)object);
        subResult.addContext("item", (Object)propertyName);
        subResult.recordFatalError("<" + propertyName + ">: " + message);
    }
}

