/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityInfoManager
extends AbstractManager {
    public void deleteUserInfoByUserIdAndKey(String userId, String key) {
        IdentityInfoEntity identityInfoEntity = this.findUserInfoByUserIdAndKey(userId, key);
        if (identityInfoEntity != null) {
            this.deleteIdentityInfo(identityInfoEntity);
        }
    }

    public void deleteIdentityInfo(IdentityInfoEntity identityInfo) {
        this.getDbSqlSession().delete(IdentityInfoEntity.class, identityInfo.getId());
        if ("account".equals(identityInfo.getType())) {
            for (IdentityInfoEntity identityInfoDetail : this.findIdentityInfoDetails(identityInfo.getId())) {
                this.getDbSqlSession().delete(IdentityInfoEntity.class, identityInfoDetail.getId());
            }
        }
    }

    public IdentityInfoEntity findUserAccountByUserIdAndKey(String userId, String userPassword, String key) {
        IdentityInfoEntity identityInfoEntity = this.findUserInfoByUserIdAndKey(userId, key);
        if (identityInfoEntity == null) {
            return null;
        }
        HashMap<String, String> details = new HashMap<String, String>();
        String identityInfoId = identityInfoEntity.getId();
        List<IdentityInfoEntity> identityInfoDetails = this.findIdentityInfoDetails(identityInfoId);
        for (IdentityInfoEntity identityInfoDetail : identityInfoDetails) {
            details.put(identityInfoDetail.getKey(), identityInfoDetail.getValue());
        }
        identityInfoEntity.setDetails(details);
        if (identityInfoEntity.getPasswordBytes() != null) {
            String password = this.decryptPassword(identityInfoEntity.getPasswordBytes(), userPassword);
            identityInfoEntity.setPassword(password);
        }
        return identityInfoEntity;
    }

    protected List<IdentityInfoEntity> findIdentityInfoDetails(String identityInfoId) {
        return Context.getCommandContext().getDbSqlSession().getSqlSession().selectList("selectIdentityInfoDetails", (Object)identityInfoId);
    }

    public void setUserInfo(String userId, String userPassword, String type, String key, String value, String accountPassword, Map<String, String> accountDetails) {
        IdentityInfoEntity identityInfoEntity;
        byte[] storedPassword = null;
        if (accountPassword != null) {
            storedPassword = this.encryptPassword(accountPassword, userPassword);
        }
        if ((identityInfoEntity = this.findUserInfoByUserIdAndKey(userId, key)) != null) {
            identityInfoEntity.setValue(value);
            identityInfoEntity.setPasswordBytes(storedPassword);
            if (accountDetails == null) {
                accountDetails = new HashMap<String, String>();
            }
            HashSet<String> newKeys = new HashSet<String>(accountDetails.keySet());
            List<IdentityInfoEntity> identityInfoDetails = this.findIdentityInfoDetails(identityInfoEntity.getId());
            for (IdentityInfoEntity identityInfoDetail : identityInfoDetails) {
                String detailKey = identityInfoDetail.getKey();
                newKeys.remove(detailKey);
                String newDetailValue = accountDetails.get(detailKey);
                if (newDetailValue == null) {
                    this.deleteIdentityInfo(identityInfoDetail);
                    continue;
                }
                identityInfoDetail.setValue(newDetailValue);
            }
            this.insertAccountDetails(identityInfoEntity, accountDetails, newKeys);
        } else {
            identityInfoEntity = new IdentityInfoEntity();
            identityInfoEntity.setUserId(userId);
            identityInfoEntity.setType(type);
            identityInfoEntity.setKey(key);
            identityInfoEntity.setValue(value);
            identityInfoEntity.setPasswordBytes(storedPassword);
            this.getDbSqlSession().insert(identityInfoEntity);
            if (accountDetails != null) {
                this.insertAccountDetails(identityInfoEntity, accountDetails, accountDetails.keySet());
            }
        }
    }

    private void insertAccountDetails(IdentityInfoEntity identityInfoEntity, Map<String, String> accountDetails, Set<String> keys) {
        for (String newKey : keys) {
            IdentityInfoEntity identityInfoDetail = new IdentityInfoEntity();
            identityInfoDetail.setParentId(identityInfoEntity.getId());
            identityInfoDetail.setKey(newKey);
            identityInfoDetail.setValue(accountDetails.get(newKey));
            this.getDbSqlSession().insert(identityInfoDetail);
        }
    }

    public byte[] encryptPassword(String accountPassword, String userPassword) {
        return accountPassword.getBytes();
    }

    public String decryptPassword(byte[] storedPassword, String userPassword) {
        return new String(storedPassword);
    }

    public IdentityInfoEntity findUserInfoByUserIdAndKey(String userId, String key) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("key", key);
        return (IdentityInfoEntity)this.getDbSqlSession().selectOne("selectIdentityInfoByUserIdAndKey", parameters);
    }

    public List<String> findUserInfoKeysByUserIdAndType(String userId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("type", type);
        return this.getDbSqlSession().getSqlSession().selectList("selectIdentityInfoKeysByUserIdAndType", parameters);
    }
}

