/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Date;
import org.activiti.engine.history.HistoricVariableUpdate;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.util.ClockUtil;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class HistoricVariableUpdateEntity
extends HistoricDetailEntity
implements ValueFields,
HistoricVariableUpdate,
PersistentObject {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected int revision;
    protected VariableType variableType;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayEntity byteArrayValue;
    protected String byteArrayValueId;
    protected Object cachedValue;

    public HistoricVariableUpdateEntity() {
    }

    public HistoricVariableUpdateEntity(VariableInstanceEntity variableInstance) {
        this.processInstanceId = variableInstance.getProcessInstanceId();
        this.executionId = variableInstance.getExecutionId();
        this.taskId = variableInstance.getTaskId();
        this.revision = variableInstance.getRevision();
        this.name = variableInstance.getName();
        this.variableType = variableInstance.getType();
        this.time = ClockUtil.getCurrentTime();
        if (variableInstance.getByteArrayValueId() != null) {
            this.byteArrayValue = new ByteArrayEntity(this.name, variableInstance.getByteArrayValue().getBytes());
            Context.getCommandContext().getDbSqlSession().insert(this.byteArrayValue);
            this.byteArrayValueId = this.byteArrayValue.getId();
        }
        this.textValue = variableInstance.getTextValue();
        this.textValue2 = variableInstance.getTextValue2();
        this.doubleValue = variableInstance.getDoubleValue();
        this.longValue = variableInstance.getLongValue();
    }

    public Object getValue() {
        if (!this.variableType.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.variableType.getValue(this);
        }
        return this.cachedValue;
    }

    public void delete() {
        super.delete();
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getSession(DbSqlSession.class).delete(ByteArrayEntity.class, this.byteArrayValueId);
        }
    }

    public ByteArrayEntity getByteArrayValue() {
        return this.byteArrayValue;
    }

    public Object getPersistentState() {
        return HistoricVariableUpdateEntity.class;
    }

    public String getVariableTypeName() {
        return this.variableType != null ? this.variableType.getTypeName() : null;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getVariableName() {
        return this.name;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public String getTextValue2() {
        return this.textValue2;
    }

    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    public void setByteArrayValue(ByteArrayEntity byteArrayValue) {
        this.byteArrayValue = byteArrayValue;
    }

    public String getByteArrayValueId() {
        return this.byteArrayValueId;
    }

    public void setByteArrayValueId(String byteArrayValueId) {
        this.byteArrayValueId = byteArrayValueId;
    }

    public Object getCachedValue() {
        return this.cachedValue;
    }

    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }
}

