/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Map<String, Object> variables;

    public CompleteTaskCmd(String taskId, Map<String, Object> variables) {
        this.taskId = taskId;
        this.variables = variables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiException("taskId is null");
        }
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiException("Cannot find task with id " + this.taskId);
        }
        if (this.variables != null) {
            task.setExecutionVariables(this.variables);
        }
        this.completeTask(task);
        return null;
    }

    protected void completeTask(TaskEntity task) {
        task.complete();
    }
}

