/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.Date;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.task.TaskDefinition;

public class UserTaskActivityBehavior
extends TaskActivityBehavior {
    protected TaskDefinition taskDefinition;
    protected ExpressionManager expressionManager;

    public UserTaskActivityBehavior(ExpressionManager expressionManager, TaskDefinition taskDefinition) {
        this.expressionManager = expressionManager;
        this.taskDefinition = taskDefinition;
    }

    public void execute(ActivityExecution execution) throws Exception {
        Object priority;
        Object dueDate;
        TaskEntity task = TaskEntity.createAndInsert(execution);
        task.setExecution(execution);
        task.setTaskDefinition(this.taskDefinition);
        if (this.taskDefinition.getNameExpression() != null) {
            String name = (String)this.taskDefinition.getNameExpression().getValue(execution);
            task.setName(name);
        }
        if (this.taskDefinition.getDescriptionExpression() != null) {
            String description = (String)this.taskDefinition.getDescriptionExpression().getValue(execution);
            task.setDescription(description);
        }
        if (this.taskDefinition.getDueDateExpression() != null && (dueDate = this.taskDefinition.getDueDateExpression().getValue(execution)) != null) {
            if (!(dueDate instanceof Date)) {
                throw new ActivitiException("Due date expression does not resolve to a Date: " + this.taskDefinition.getDueDateExpression().getExpressionText());
            }
            task.setDueDate((Date)dueDate);
        }
        if (this.taskDefinition.getPriorityExpression() != null && (priority = this.taskDefinition.getPriorityExpression().getValue(execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority));
                }
                catch (NumberFormatException e) {
                    throw new ActivitiException("Priority does not resolve to a number: " + priority, e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiException("Priority expression does not resolve to a number: " + this.taskDefinition.getPriorityExpression().getExpressionText());
            }
        }
        this.handleAssignments(task, execution);
        task.fireEvent("create");
    }

    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        this.leave(execution);
    }

    protected void handleAssignments(TaskEntity task, ActivityExecution execution) {
        Object value;
        if (this.taskDefinition.getAssigneeExpression() != null) {
            task.setAssignee((String)this.taskDefinition.getAssigneeExpression().getValue(execution));
        }
        if (!this.taskDefinition.getCandidateGroupIdExpressions().isEmpty()) {
            for (Expression groupIdExpr : this.taskDefinition.getCandidateGroupIdExpressions()) {
                value = groupIdExpr.getValue(execution);
                if (value instanceof String) {
                    task.addCandidateGroup((String)value);
                    continue;
                }
                if (value instanceof Collection) {
                    task.addCandidateGroups((Collection)value);
                    continue;
                }
                throw new ActivitiException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (!this.taskDefinition.getCandidateUserIdExpressions().isEmpty()) {
            for (Expression userIdExpr : this.taskDefinition.getCandidateUserIdExpressions()) {
                value = userIdExpr.getValue(execution);
                if (value instanceof String) {
                    task.addCandidateUser((String)value);
                    continue;
                }
                if (value instanceof Collection) {
                    task.addCandidateUsers((Collection)value);
                    continue;
                }
                throw new ActivitiException("Expression did not resolve to a string or collection of strings");
            }
        }
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }
}

