/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching.version;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.util.collections.MostRecentlyUsedMap;
import org.apache.wicket.util.lang.Args;

public class CachingResourceVersion
implements IResourceVersion {
    private static final int DEFAULT_MAX_CACHE_ENTRIES = 5000;
    private static final String NULL_VALUE = "null";
    private final IResourceVersion delegate;
    private final Map<Serializable, String> cache;

    public CachingResourceVersion(IResourceVersion delegate) {
        this(delegate, 5000);
    }

    public CachingResourceVersion(IResourceVersion delegate, int maxEntries) {
        if (maxEntries < 1) {
            throw new IllegalArgumentException("maxEntries must be greater than zero");
        }
        this.delegate = (IResourceVersion)Args.notNull((Object)delegate, (String)"delegate");
        this.cache = Collections.synchronizedMap(new MostRecentlyUsedMap(maxEntries));
    }

    public String getVersion(IStaticCacheableResource resource) {
        Serializable key = resource.getCacheKey();
        if (key == null) {
            return null;
        }
        String version = this.cache.get(key);
        if (version == null) {
            version = this.delegate.getVersion(resource);
            if (version == null) {
                version = NULL_VALUE;
            }
            this.cache.put(key, version);
        }
        if (version == NULL_VALUE) {
            return null;
        }
        return version;
    }

    public void invalidate(IStaticCacheableResource resource) {
        Serializable key = ((IStaticCacheableResource)Args.notNull((Object)resource, (String)"resource")).getCacheKey();
        if (key != null) {
            this.cache.remove(key);
        }
    }
}

