/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet.servicelist;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.servlet.servicelist.ServiceListWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattedServiceListWriter
implements ServiceListWriter {
    private String styleSheetPath;
    private String title;
    private Map<String, String> atomMap;

    public FormattedServiceListWriter(String styleSheetPath, String title, Map<String, String> atomMap) {
        this.styleSheetPath = styleSheetPath;
        this.title = title;
        this.atomMap = atomMap;
    }

    @Override
    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    @Override
    public void writeServiceList(PrintWriter writer, String basePath, AbstractDestination[] soapDestinations, AbstractDestination[] restDestinations) throws IOException {
        writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.write("<HTML><HEAD>");
        writer.write("<LINK type=\"text/css\" rel=\"stylesheet\" href=\"" + this.styleSheetPath + "\">");
        writer.write("<meta http-equiv=content-type content=\"text/html; charset=UTF-8\">");
        if (this.title != null) {
            writer.write("<title>" + this.title + "</title>");
        } else {
            writer.write("<title>CXF - Service list</title>");
        }
        writer.write("</head><body>");
        if (soapDestinations.length > 0 || restDestinations.length > 0) {
            this.writeSOAPEndpoints(writer, basePath, soapDestinations);
            this.writeRESTfulEndpoints(writer, basePath, restDestinations);
        } else {
            writer.write("<span class=\"heading\">No services have been found.</span>");
        }
        writer.write("</body></html>");
    }

    private void writeSOAPEndpoints(PrintWriter writer, String basePath, AbstractDestination[] destinations) throws IOException {
        writer.write("<span class=\"heading\">Available SOAP services:</span><br/>");
        writer.write("<table " + (this.styleSheetPath.endsWith("stylesheet=1") ? "cellpadding=\"1\" cellspacing=\"1\" border=\"1\" width=\"100%\"" : "") + ">");
        for (AbstractDestination sd : destinations) {
            this.writerSoapEndpoint(writer, basePath, sd);
        }
        writer.write("</table><br/><br/>");
    }

    private void writerSoapEndpoint(PrintWriter writer, String basePath, AbstractDestination sd) {
        writer.write("<tr><td>");
        writer.write("<span class=\"porttypename\">" + sd.getEndpointInfo().getInterface().getName().getLocalPart() + "</span>");
        writer.write("<ul>");
        for (OperationInfo oi : sd.getEndpointInfo().getInterface().getOperations()) {
            if (oi.getProperty("operation.is.synthetic") == Boolean.TRUE) continue;
            writer.write("<li>" + oi.getName().getLocalPart() + "</li>");
        }
        writer.write("</ul>");
        writer.write("</td><td>");
        String absoluteURL = this.getAbsoluteAddress(basePath, sd);
        writer.write("<span class=\"field\">Endpoint address:</span> <span class=\"value\">" + absoluteURL + "</span>");
        writer.write("<br/><span class=\"field\">WSDL :</span> <a href=\"" + absoluteURL + "?wsdl\">" + sd.getEndpointInfo().getService().getName() + "</a>");
        writer.write("<br/><span class=\"field\">Target namespace:</span> <span class=\"value\">" + sd.getEndpointInfo().getService().getTargetNamespace() + "</span>");
        FormattedServiceListWriter.addAtomLinkIfNeeded(absoluteURL, this.atomMap, writer);
        writer.write("</td></tr>");
    }

    private String getAbsoluteAddress(String basePath, AbstractDestination d) {
        String endpointAddress = (String)d.getEndpointInfo().getProperty("publishedEndpointUrl");
        if (endpointAddress != null) {
            return endpointAddress;
        }
        endpointAddress = d.getEndpointInfo().getAddress();
        if (basePath == null || endpointAddress.startsWith(basePath)) {
            return endpointAddress;
        }
        return basePath + endpointAddress;
    }

    private void writeRESTfulEndpoints(PrintWriter writer, String basePath, AbstractDestination[] restfulDests) throws IOException {
        writer.write("<span class=\"heading\">Available RESTful services:</span><br/>");
        writer.write("<table " + (this.styleSheetPath.endsWith("stylesheet=1") ? "cellpadding=\"1\" cellspacing=\"1\" border=\"1\" width=\"100%\"" : "") + ">");
        for (AbstractDestination sd : restfulDests) {
            this.writeRESTfulEndpoint(writer, basePath, sd);
        }
        writer.write("</table>");
    }

    private void writeRESTfulEndpoint(PrintWriter writer, String basePath, AbstractDestination sd) {
        String absoluteURL = this.getAbsoluteAddress(basePath, sd);
        writer.write("<tr><td>");
        writer.write("<span class=\"field\">Endpoint address:</span> <span class=\"value\">" + absoluteURL + "</span>");
        writer.write("<br/><span class=\"field\">WADL :</span> <a href=\"" + absoluteURL + "?_wadl&_type=xml\">" + absoluteURL + "?_wadl&type=xml" + "</a>");
        FormattedServiceListWriter.addAtomLinkIfNeeded(absoluteURL, this.atomMap, writer);
        writer.write("</td></tr>");
    }

    private static void addAtomLinkIfNeeded(String address, Map<String, String> extMap, PrintWriter pw) {
        String atomAddress = FormattedServiceListWriter.getExtensionEndpointAddress(address, extMap);
        if (atomAddress != null) {
            pw.write("<br/><span class=\"field\">Atom Log Feed :</span> <a href=\"" + atomAddress + "\">" + atomAddress + "</a>");
        }
    }

    private static String getExtensionEndpointAddress(String endpointAddress, Map<String, String> extMap) {
        if (extMap != null) {
            for (Map.Entry<String, String> entry : extMap.entrySet()) {
                if (!endpointAddress.endsWith(entry.getKey())) continue;
                endpointAddress = endpointAddress.substring(0, endpointAddress.length() - entry.getKey().length());
                endpointAddress = endpointAddress + entry.getValue();
                return endpointAddress;
            }
        }
        return null;
    }
}

