/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.impl.AbstractSignableSAMLObject;
import org.opensaml.saml1.core.Advice;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml1.core.Conditions;
import org.opensaml.saml1.core.Statement;
import org.opensaml.saml1.core.SubjectStatement;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.IndexedXMLObjectChildrenList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionImpl
extends AbstractSignableSAMLObject
implements Assertion {
    private String id;
    private SAMLVersion version;
    private String issuer;
    private DateTime issueInstant;
    private Conditions conditions;
    private Advice advice;
    private final IndexedXMLObjectChildrenList<Statement> statements = new IndexedXMLObjectChildrenList((XMLObject)this);

    protected AssertionImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.version = SAMLVersion.VERSION_11;
    }

    @Override
    public int getMajorVersion() {
        return this.version.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.version.getMinorVersion();
    }

    @Override
    public void setVersion(SAMLVersion newVersion) {
        this.version = (SAMLVersion)this.prepareForAssignment(this.version, newVersion);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, id);
        this.registerOwnID(oldID, this.id);
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public void setIssuer(String issuer) {
        this.issuer = this.prepareForAssignment(this.issuer, issuer);
    }

    @Override
    public DateTime getIssueInstant() {
        return this.issueInstant;
    }

    @Override
    public void setIssueInstant(DateTime issueInstant) {
        this.issueInstant = this.prepareForAssignment(this.issueInstant, issueInstant);
    }

    @Override
    public Conditions getConditions() {
        return this.conditions;
    }

    @Override
    public void setConditions(Conditions conditions) throws IllegalArgumentException {
        this.conditions = (Conditions)this.prepareForAssignment((XMLObject)this.conditions, (XMLObject)conditions);
    }

    @Override
    public Advice getAdvice() {
        return this.advice;
    }

    @Override
    public void setAdvice(Advice advice) throws IllegalArgumentException {
        this.advice = (Advice)this.prepareForAssignment((XMLObject)this.advice, (XMLObject)advice);
    }

    @Override
    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public List<Statement> getStatements(QName typeOrName) {
        return this.statements.subList(typeOrName);
    }

    @Override
    public List<SubjectStatement> getSubjectStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectStatement");
        return this.statements.subList(statementQName);
    }

    @Override
    public List<AuthenticationStatement> getAuthenticationStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
        return this.statements.subList(statementQName);
    }

    @Override
    public List<AuthorizationDecisionStatement> getAuthorizationDecisionStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement");
        return this.statements.subList(statementQName);
    }

    @Override
    public List<AttributeStatement> getAttributeStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement");
        return this.statements.subList(statementQName);
    }

    @Override
    public String getSignatureReferenceID() {
        return this.id;
    }

    public List<XMLObject> getOrderedChildren() {
        ArrayList<SAMLObject> children = new ArrayList<SAMLObject>();
        if (this.conditions != null) {
            children.add(this.conditions);
        }
        if (this.advice != null) {
            children.add(this.advice);
        }
        children.addAll((Collection<SAMLObject>)this.statements);
        if (this.getSignature() != null) {
            children.add((SAMLObject)this.getSignature());
        }
        if (children.size() == 0) {
            return null;
        }
        return Collections.unmodifiableList(children);
    }
}

