/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server.impl;

import org.identityconnectors.common.logging.Log;

public class CCLWatchThread
extends Thread {
    private static final Log _log = Log.getLog(CCLWatchThread.class);

    public CCLWatchThread(String name) {
        super(name);
        this.checkCCL();
    }

    public CCLWatchThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
        this.checkCCL();
    }

    private void checkCCL() {
        if (this.getContextClassLoader() == null) {
            _log.error(new Throwable(), "The CCL of thread ''{0}'' was null after initialization. The CCL of current thread ''{1}'' is {2}", this.getName(), Thread.currentThread().getName(), Thread.currentThread().getContextClassLoader());
        } else {
            _log.info("Creating thread ''{0}'' with a non-null CCL", this.getName());
        }
    }

    public void setContextClassLoader(ClassLoader cl) {
        if (cl == null) {
            _log.error(new Throwable(), "Attempting to set the CCL of thread ''{0}'' to null", this.getName());
        }
        super.setContextClassLoader(cl);
    }
}

